/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.impl;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitLabApiException;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.IssueFilterBuilder;
import at.rumpelcoders.confluence.beans.MilestonesFilterBuilder;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabBranch;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabCommit;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabCommitDiff;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabEpic;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabEpicIssues;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabIssue;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabJob;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabMilestone;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabRelease;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabSnippet;
import at.rumpelcoders.confluence.beans.apiwrapper.Note;
import at.rumpelcoders.confluence.beans.model.GitlabNote;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.inject.Named;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.Pagination;
import org.gitlab.api.TokenType;
import org.gitlab.api.http.Query;
import org.gitlab.api.models.GitlabGroup;
import org.gitlab.api.models.GitlabMergeRequest;
import org.gitlab.api.models.GitlabRepositoryFile;
import org.gitlab.api.models.GitlabTag;
import org.gitlab.api.models.GitlabVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={GitlabApi.class})
@Named(value="gitlabApi")
public class GitlabApiImpl
implements GitlabApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitlabApiImpl.class);
    public static final int OPEN_ORDER = 1;
    public static final int CLOSED_ORDER = 2;
    protected static final int MAX_EPIC_ISSUES_COUNT = 1000;
    protected static final int MAX_PER_PAGE = 100;

    @Override
    public List<at.rumpelcoders.confluence.beans.apiwrapper.GitlabMergeRequest> getMergeRequestsWithProjectId(GitlabConnection gitlabConnection, Integer projectId) throws GitLabApiException {
        try {
            return this.getApi(gitlabConnection).getMergeRequests(projectId).stream().map(at.rumpelcoders.confluence.beans.apiwrapper.GitlabMergeRequest::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public List<GitlabIssue> getIssues(GitlabConnection connection, Serializable projectId, IssueFilterBuilder filterBuilder) throws GitLabApiException {
        StringBuilder tailUrl = new StringBuilder("/projects/" + projectId + "/issues");
        ArrayList allIssues = new ArrayList();
        try {
            ArrayList<org.gitlab.api.models.GitlabIssue> fetchedData = new ArrayList<org.gitlab.api.models.GitlabIssue>();
            int page = 1;
            do {
                fetchedData.clear();
                String issueUrl = filterBuilder.build(tailUrl.toString(), page).toString();
                fetchedData.addAll(Arrays.asList(this.getApi(connection).retrieve().to(issueUrl, org.gitlab.api.models.GitlabIssue[].class)));
                allIssues.addAll(fetchedData);
                ++page;
            } while (allIssues.size() < filterBuilder.getMaximumEntries() && !fetchedData.isEmpty());
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
        ArrayList<GitlabIssue> gitlabIssues = new ArrayList<GitlabIssue>();
        for (org.gitlab.api.models.GitlabIssue issue : allIssues) {
            gitlabIssues.add(new GitlabIssue(issue));
            if (gitlabIssues.size() < filterBuilder.getMaximumEntries()) continue;
            break;
        }
        return gitlabIssues;
    }

    @Override
    public List<GitlabGroup> getGitlabSubGroups(GitlabConnection connection, Integer groupId, int count, boolean directSubGroupsOnly) throws GitLabApiException {
        ArrayList<GitlabGroup> groups = new ArrayList<GitlabGroup>();
        count = count <= 0 ? 100 : count;
        String path = "/groups/" + groupId + (directSubGroupsOnly ? "/subgroups" : "/descendant_groups");
        try {
            ArrayList<GitlabGroup> fetchedData = new ArrayList<GitlabGroup>();
            int page = 1;
            do {
                fetchedData.clear();
                Query query = new Query();
                query.append("order_by", "path");
                query.mergeWith(new Pagination().withPerPage(Math.min(count, 100)).withPage(page).asQuery());
                String tailUrl = path + query.toString();
                fetchedData.addAll(Arrays.asList(this.getApi(connection).retrieve().to(tailUrl, GitlabGroup[].class)));
                groups.addAll(fetchedData);
                ++page;
            } while (!fetchedData.isEmpty() && groups.size() < count);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
        return groups;
    }

    @Override
    public GitlabGroup getGitlabGroup(GitlabConnection connection, String groupId) throws GitLabApiException {
        String tailUrl = "/groups/" + groupId;
        try {
            return this.getApi(connection).retrieve().to(tailUrl, GitlabGroup.class);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public List<GitlabGroup> getGitlabGroups(GitlabConnection connection, int count, boolean topLevelOnly) throws GitLabApiException {
        ArrayList<GitlabGroup> groups = new ArrayList<GitlabGroup>();
        count = count <= 0 ? 100 : count;
        try {
            ArrayList<GitlabGroup> fetchedData = new ArrayList<GitlabGroup>();
            int page = 1;
            do {
                fetchedData.clear();
                Query query = new Query();
                query.append("top_level_only", String.valueOf(topLevelOnly));
                query.append("order_by", "path");
                query.mergeWith(new Pagination().withPerPage(Math.min(count, 100)).withPage(page).asQuery());
                String tailUrl = "/groups" + query.toString();
                fetchedData.addAll(Arrays.asList(this.getApi(connection).retrieve().to(tailUrl, GitlabGroup[].class)));
                groups.addAll(fetchedData);
                ++page;
            } while (!fetchedData.isEmpty() && groups.size() < count);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
        return groups;
    }

    @Override
    public List<GitlabEpic> getGitlabEpics(GitlabConnection connection, int groupId) {
        return this.getApi(connection).retrieve().getAll("/groups/" + groupId + "/epics/", GitlabEpic[].class);
    }

    @Override
    public GitlabEpic getGitlabEpic(GitlabConnection connection, int groupId, int epicIid) throws GitLabApiException {
        StringBuilder tailUrl = new StringBuilder("/groups/" + groupId + "/epics/" + epicIid);
        try {
            return this.getApi(connection).retrieve().to(tailUrl.toString(), GitlabEpic.class);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public GitlabEpicIssues getGitlabEpicIssues(GitlabConnection connection, int groupId, int epicIid, IssueFilterBuilder filterBuilder) throws GitLabApiException {
        StringBuilder tailUrl = new StringBuilder("/groups/" + groupId + "/epics/" + epicIid + "/issues");
        ArrayList allIssues = new ArrayList();
        try {
            ArrayList<org.gitlab.api.models.GitlabIssue> fetchedData = new ArrayList<org.gitlab.api.models.GitlabIssue>();
            int page = 1;
            do {
                fetchedData.clear();
                String issueUrl = filterBuilder.build(tailUrl.toString(), page).toString();
                fetchedData.addAll(Arrays.asList(this.getApi(connection).retrieve().to(issueUrl, org.gitlab.api.models.GitlabIssue[].class)));
                allIssues.addAll(fetchedData);
                ++page;
            } while (!fetchedData.isEmpty() && allIssues.size() < 1000);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
        ArrayList<GitlabIssue> gitlabIssues = new ArrayList<GitlabIssue>();
        for (org.gitlab.api.models.GitlabIssue issue : allIssues) {
            gitlabIssues.add(new GitlabIssue(issue));
        }
        gitlabIssues.sort((o1, o2) -> {
            Integer o2State;
            Integer o1State = "opened".equals(o1.getState()) ? 1 : 2;
            int result = o1State.compareTo(o2State = Integer.valueOf("opened".equals(o2.getState()) ? 1 : 2));
            if (result == 0) {
                result = o1.getUpdatedAt().compareTo(o2.getUpdatedAt());
            }
            return result;
        });
        GitlabEpicIssues result = new GitlabEpicIssues();
        result.setTotal(gitlabIssues.size()).setOpenCount((int)gitlabIssues.stream().filter(i -> "opened".equals(i.getState())).count()).setClosedCount((int)gitlabIssues.stream().filter(i -> "closed".equals(i.getState())).count()).setIssues(gitlabIssues.subList(0, Math.min(gitlabIssues.size(), filterBuilder.getMaximumEntries()))).setEpicId(epicIid);
        return result;
    }

    @Override
    public GitlabProject getProject(GitlabConnection connection, Serializable projectId, boolean fetchTags) throws GitLabApiException {
        org.gitlab.api.models.GitlabProject gitlabProject = null;
        try {
            gitlabProject = this.getApi(connection).getProject(projectId);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
        GitlabProject result = new GitlabProject(gitlabProject);
        if (fetchTags && CollectionUtils.isEmpty(result.getTagList())) {
            List<GitlabTag> tagList = this.getApi(connection).getTags(projectId);
            result.setTagList(tagList.stream().map(GitlabTag::getName).collect(Collectors.toList()));
        }
        return result;
    }

    @Override
    public List<GitlabBranch> getBranches(GitlabConnection connection, Serializable projectId) throws GitLabApiException {
        try {
            return this.getApi(connection).getBranches(projectId).stream().map(GitlabBranch::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public List<GitlabBranch> searchBranches(GitlabConnection connection, Serializable projectId, int limit, String text) throws GitLabApiException {
        ArrayList<GitlabBranch> branches = new ArrayList<GitlabBranch>();
        try {
            ArrayList<GitlabBranch> fetchedData = new ArrayList<GitlabBranch>();
            int page = 1;
            do {
                fetchedData.clear();
                Query query = new Query();
                query.mergeWith(new Pagination().withPerPage(100).withPage(page).asQuery());
                String tailUrl = "/projects/" + projectId + "/repository/branches" + query.toString();
                fetchedData.addAll(Arrays.asList(this.getApi(connection).retrieve().to(tailUrl, GitlabBranch[].class)));
                fetchedData.forEach(branch -> {
                    if (branches.size() < limit && (text == null || branch.getName().toLowerCase().contains(text.toLowerCase()))) {
                        branches.add((GitlabBranch)branch);
                    }
                });
                ++page;
            } while (!fetchedData.isEmpty() && branches.size() < limit);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
        return branches;
    }

    @Override
    public List<GitlabRelease> getReleases(GitlabConnection connection, Serializable projectId) throws GitLabApiException {
        try {
            projectId = projectId instanceof String ? URLEncoder.encode((String)((Object)projectId), StandardCharsets.UTF_8.displayName()) : projectId;
            String tailUrl = "/projects/" + projectId + "/releases";
            return Arrays.asList(this.getApi(connection).retrieve().to(tailUrl, GitlabRelease[].class));
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public GitlabRelease getRelease(GitlabConnection connection, int projectId, String tag) throws GitLabApiException {
        String tailUrl = "/projects/" + projectId + "/releases/" + tag;
        try {
            return this.getApi(connection).retrieve().to(tailUrl, GitlabRelease.class);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public List<GitlabCommit> getCommits(GitlabConnection gitlabConnection, int projectId, String fromTag, String toTag, int commitsCount) throws GitLabApiException {
        ArrayList<GitlabCommit> commits = new ArrayList<GitlabCommit>();
        try {
            ArrayList<GitlabCommit> fetchedData = new ArrayList<GitlabCommit>();
            int page = 1;
            do {
                fetchedData.clear();
                Query query = new Query();
                query.append("ref_name", fromTag + ".." + toTag);
                query.mergeWith(new Pagination().withPerPage(Math.min(commitsCount, 100)).withPage(page).asQuery());
                String tailUrl = "/projects/" + projectId + "/repository/commits" + query.toString();
                fetchedData.addAll(Arrays.asList(this.getApi(gitlabConnection).retrieve().to(tailUrl, GitlabCommit[].class)));
                commits.addAll(fetchedData);
                ++page;
            } while (!fetchedData.isEmpty() && commits.size() < commitsCount);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
        return commits;
    }

    @Override
    public List<at.rumpelcoders.confluence.beans.apiwrapper.GitlabMergeRequest> getCommitMergeRequest(GitlabConnection connection, int projectId, String commitId) throws GitLabApiException {
        String tailUrl = "/projects/" + projectId + "/repository/commits/" + commitId + "/merge_requests";
        try {
            return Arrays.stream(this.getApi(connection).retrieve().to(tailUrl, GitlabMergeRequest[].class)).map(at.rumpelcoders.confluence.beans.apiwrapper.GitlabMergeRequest::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public List<GitlabIssue> getMilestoneIssues(GitlabConnection connection, Serializable projectId, String milestoneId, IssueFilterBuilder filterBuilder) throws GitLabApiException {
        ArrayList<org.gitlab.api.models.GitlabIssue> issues = new ArrayList<org.gitlab.api.models.GitlabIssue>();
        int count = filterBuilder.getMaximumEntries() <= 0 ? 100 : filterBuilder.getMaximumEntries();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Date fromDate = filterBuilder.getFromDate() == null ? null : dateFormat.parse(filterBuilder.getFromDate());
        Date toDate = filterBuilder.getToDate() == null ? null : dateFormat.parse(filterBuilder.getToDate());
        try {
            ArrayList<org.gitlab.api.models.GitlabIssue> fetchedData = new ArrayList<org.gitlab.api.models.GitlabIssue>();
            int page = 1;
            do {
                fetchedData.clear();
                Query query = this.toProjectQuery(page, count, false);
                String tailUrl = "/projects/" + projectId + "/milestones/" + milestoneId + "/issues" + query.toString();
                fetchedData.addAll(Arrays.asList(this.getApi(connection).retrieve().to(tailUrl, org.gitlab.api.models.GitlabIssue[].class)));
                for (org.gitlab.api.models.GitlabIssue issue : fetchedData) {
                    boolean withinDateRange;
                    Date createdAt = issue.getCreatedAt();
                    boolean bl = withinDateRange = fromDate == null || createdAt == null || !createdAt.before(fromDate);
                    if (toDate != null && createdAt != null && createdAt.after(toDate)) {
                        withinDateRange = false;
                    }
                    if (!withinDateRange || issues.size() >= count) continue;
                    issues.add(issue);
                }
                ++page;
            } while (!fetchedData.isEmpty() && issues.size() < count);
            return issues.stream().map(GitlabIssue::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public List<GitlabMilestone> getMilestones(GitlabConnection connection, Serializable projectId, MilestonesFilterBuilder filterBuilder) throws GitLabApiException {
        StringBuilder tailUrl = new StringBuilder("/projects/" + projectId + "/milestones");
        ArrayList allMilestones = new ArrayList();
        try {
            ArrayList<org.gitlab.api.models.GitlabMilestone> fetchedData = new ArrayList<org.gitlab.api.models.GitlabMilestone>();
            int page = 1;
            do {
                fetchedData.clear();
                String issueUrl = filterBuilder.build(tailUrl.toString(), page);
                fetchedData.addAll(Arrays.asList(this.getApi(connection).retrieve().to(issueUrl, org.gitlab.api.models.GitlabMilestone[].class)));
                allMilestones.addAll(fetchedData);
                ++page;
            } while (allMilestones.size() < filterBuilder.getMaximumEntries() && !fetchedData.isEmpty());
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
        ArrayList<GitlabMilestone> gitlabMilestones = new ArrayList<GitlabMilestone>();
        for (org.gitlab.api.models.GitlabMilestone issue : allMilestones) {
            gitlabMilestones.add(new GitlabMilestone(issue));
            if (gitlabMilestones.size() < filterBuilder.getMaximumEntries()) continue;
            break;
        }
        return gitlabMilestones;
    }

    @Override
    public GitlabMilestone getMilestone(GitlabConnection connection, Serializable projectId, int milestoneId) throws GitLabApiException {
        String tailUrl = "/projects/" + this.sanitizeId(projectId) + "/milestones/" + milestoneId;
        try {
            org.gitlab.api.models.GitlabMilestone milestone = this.getApi(connection).retrieve().to(tailUrl, org.gitlab.api.models.GitlabMilestone.class);
            return new GitlabMilestone(milestone);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public GitlabCommit getCommit(GitlabConnection connection, int projectId, String commitHash) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getApi(connection).getCommit(Integer.valueOf(projectId), commitHash)).map(GitlabCommit::new).orElse(null);
        }
        catch (Exception e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public List<GitlabCommitDiff> getCommitDiff(GitlabConnection connection, int projectId, String commitHash) throws GitLabApiException {
        try {
            return this.getApi(connection).getCommitDiffs(Integer.valueOf(projectId), commitHash).stream().map(GitlabCommitDiff::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public List<GitlabJob> getBuilds(GitlabConnection connection, int projectId, int count) throws GitLabApiException {
        try {
            count = Math.min(count, 100);
            String tailUrl = "/projects/" + projectId + "/jobs?per_page=" + count;
            GitlabJob[] result = this.getApi(connection).retrieve().to(tailUrl, GitlabJob[].class);
            return Arrays.asList(result);
        }
        catch (Exception e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public GitlabIssue getIssue(GitlabConnection connection, Serializable projectId, int issueId) throws GitLabApiException {
        org.gitlab.api.models.GitlabIssue issue = null;
        try {
            issue = this.getApi(connection).getIssue(projectId, issueId);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
        return new GitlabIssue(issue);
    }

    @Override
    public GitlabVersion getVersion(GitlabConnection gitlabConnection) throws GitLabApiException {
        try {
            return this.getApi(gitlabConnection).getVersion();
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public List<GitlabIssue> searchIssues(GitlabConnection gitlabConnection, Serializable projectId, String text) throws GitLabApiException {
        List<org.gitlab.api.models.GitlabIssue> issues = null;
        try {
            projectId = projectId instanceof String ? URLEncoder.encode((String)((Object)projectId), StandardCharsets.UTF_8.displayName()) : projectId;
            Query query = new Query().append("search", text).append("in", "title");
            String tailUrl = "/projects/" + projectId + "/issues" + query.toString();
            org.gitlab.api.models.GitlabIssue[] response = this.getApi(gitlabConnection).retrieve().to(tailUrl, org.gitlab.api.models.GitlabIssue[].class);
            issues = Arrays.asList(response);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
        return issues.stream().map(GitlabIssue::new).collect(Collectors.toList());
    }

    @Override
    public List<GitlabProject> searchProjects(GitlabConnection gitlabConnection, String text) throws GitLabApiException {
        List<org.gitlab.api.models.GitlabProject> projects = null;
        try {
            Query query = new Query().append("search", text).append("membership", "true");
            String tailUrl = "/projects" + query.toString();
            org.gitlab.api.models.GitlabProject[] response = this.getApi(gitlabConnection).retrieve().to(tailUrl, org.gitlab.api.models.GitlabProject[].class);
            projects = Arrays.asList(response);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
        return projects.stream().map(GitlabProject::new).collect(Collectors.toList());
    }

    @Override
    public List<GitlabProject> getProjects(GitlabConnection gitlabConnection, int count, boolean fetchTags) throws GitLabApiException {
        ArrayList projects = new ArrayList();
        count = count <= 0 ? 100 : count;
        try {
            ArrayList<org.gitlab.api.models.GitlabProject> fetchedData = new ArrayList<org.gitlab.api.models.GitlabProject>();
            int page = 1;
            do {
                fetchedData.clear();
                Query query = this.toProjectQuery(page, count, GitlabConnection.HostType.CLOUD.equals((Object)gitlabConnection.getHostType()));
                String tailUrl = "/projects" + query.toString();
                fetchedData.addAll(Arrays.asList(this.getApi(gitlabConnection).retrieve().to(tailUrl, org.gitlab.api.models.GitlabProject[].class)));
                projects.addAll(fetchedData);
                ++page;
            } while (!fetchedData.isEmpty() && projects.size() < count);
            return projects.stream().map(gitlabProject -> {
                GitlabProject result = new GitlabProject((org.gitlab.api.models.GitlabProject)gitlabProject);
                if (fetchTags && CollectionUtils.isEmpty(result.getTagList())) {
                    List<GitlabTag> tagList = this.getApi(gitlabConnection).getTags(gitlabProject.getId());
                    result.setTagList(tagList.stream().map(GitlabTag::getName).collect(Collectors.toList()));
                }
                return result;
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
    }

    private Query toProjectQuery(int page, int count, boolean membership) {
        Query query = new Query();
        if (membership) {
            query.append("membership", "true");
        }
        query.mergeWith(new Pagination().withPerPage(Math.min(count, 100)).withPage(page).asQuery());
        return query;
    }

    @Override
    public List<GitlabProject> getGroupProjects(GitlabConnection gitlabConnection, Integer groupId, int count) throws GitLabApiException {
        ArrayList projects = new ArrayList();
        count = count <= 0 ? 100 : count;
        try {
            ArrayList<org.gitlab.api.models.GitlabProject> fetchedData = new ArrayList<org.gitlab.api.models.GitlabProject>();
            int page = 1;
            do {
                fetchedData.clear();
                Query query = this.toProjectQuery(page, count, false);
                String tailUrl = "/groups/" + groupId + "/projects" + query.toString();
                fetchedData.addAll(Arrays.asList(this.getApi(gitlabConnection).retrieve().to(tailUrl, org.gitlab.api.models.GitlabProject[].class)));
                projects.addAll(fetchedData);
                ++page;
            } while (!fetchedData.isEmpty() && projects.size() < count);
            return projects.stream().map(gitlabProject -> {
                GitlabProject result = new GitlabProject((org.gitlab.api.models.GitlabProject)gitlabProject);
                if (CollectionUtils.isEmpty(result.getTagList())) {
                    List<GitlabTag> tagList = this.getApi(gitlabConnection).getTags(gitlabProject.getId());
                    result.setTagList(tagList.stream().map(GitlabTag::getName).collect(Collectors.toList()));
                }
                return result;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public List<GitlabIssue> getIssues(GitlabConnection connection, GitlabProject project, Integer ... iids) throws GitLabApiException {
        String tailUrl = "/projects/" + project.getId() + "/issues";
        StringJoiner stringJoiner = new StringJoiner(", iids[]=");
        if (iids != null && iids.length > 0) {
            for (Integer iid : iids) {
                stringJoiner.add(iid.toString());
            }
            tailUrl = tailUrl + "?iids[]=" + stringJoiner.toString() + "&per_page=100";
        }
        try {
            return Arrays.stream(this.getApi(connection).retrieve().to(tailUrl, org.gitlab.api.models.GitlabIssue[].class)).map(GitlabIssue::new).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public List<Note> getNotesForIssue(GitlabConnection connection, GitlabIssue issue) throws GitLabApiException {
        List<GitlabNote> notes = null;
        try {
            String tailUrl = "/projects/" + issue.getProjectId() + "/issues/" + issue.getIid() + "/notes";
            notes = Arrays.asList(this.getApi(connection).retrieve().to(tailUrl, GitlabNote[].class));
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
        ArrayList<Note> wrappedNotes = new ArrayList<Note>();
        notes.forEach(gitlabNote -> wrappedNotes.add(new Note((GitlabNote)gitlabNote)));
        Collections.sort(wrappedNotes);
        return wrappedNotes;
    }

    @Override
    public GitlabRepositoryFile getRepositoryFile(GitlabConnection connection, Integer projectId, String path, String ref) throws GitLabApiException {
        org.gitlab.api.models.GitlabProject gitlabProject = new org.gitlab.api.models.GitlabProject();
        gitlabProject.setId(projectId);
        try {
            return this.getApi(connection).getRepositoryFile(gitlabProject, path, ref);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public List<GitlabSnippet> getProjectSnippets(GitlabConnection gitlabConnection, Serializable projectId) throws GitLabApiException {
        List<GitlabSnippet> snippets = null;
        try {
            projectId = projectId instanceof String ? URLEncoder.encode((String)((Object)projectId), StandardCharsets.UTF_8.displayName()) : projectId;
            String tailUrl = "/projects/" + projectId + "/snippets";
            GitlabSnippet[] response = this.getApi(gitlabConnection).retrieve().to(tailUrl, GitlabSnippet[].class);
            snippets = Arrays.asList(response);
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
        return snippets;
    }

    @Override
    public GitlabSnippet getSnippet(GitlabConnection connection, int projectId, int snippetId) throws GitLabApiException {
        try {
            String tailUrl = "/projects/" + projectId + "/snippets/" + snippetId;
            GitlabSnippet snippet = this.getApi(connection).retrieve().to(tailUrl, GitlabSnippet.class);
            String content = this.getApi(connection).retrieve().to(tailUrl + "/raw", String.class);
            snippet.setContent(content);
            return snippet;
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
    }

    @Override
    public GitlabSnippet getSnippet(GitlabConnection connection, int snippetId) throws GitLabApiException {
        try {
            String tailUrl = "/snippets/" + snippetId;
            GitlabSnippet snippet = this.getApi(connection).retrieve().to(tailUrl, GitlabSnippet.class);
            String content = this.getApi(connection).retrieve().to(tailUrl + "/raw", String.class);
            snippet.setContent(content);
            return snippet;
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
    }

    protected GitlabAPI getApi(GitlabConnection connection) {
        return GitlabAPI.connect(connection.getUrl(), connection.getApiKey(), TokenType.ACCESS_TOKEN).setResponseReadTimeout(connection.getRequestTimeout() * 1000).setConnectionTimeout(connection.getRequestTimeout() * 1000);
    }

    private String sanitizeId(Serializable id) {
        if (!(id instanceof String) && !(id instanceof Number)) {
            throw new IllegalArgumentException("parameter needs to be of type String or Number");
        }
        try {
            return URLEncoder.encode(String.valueOf(id), "UTF-8");
        }
        catch (UnsupportedEncodingException var4) {
            UnsupportedEncodingException e = var4;
            throw new RuntimeException(e);
        }
    }
}

