/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.beans.model;

import at.rumpelcoders.confluence.beans.apiwrapper.GitlabIssue;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Date;
import lombok.Generated;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class GitlabChartIssue {
    private int id;
    private int iid;
    private int projectId;
    private String title;
    private String state;
    private Date startDate;
    private Date endDate;
    private Date closedDate;
    private String webUrl;
    private boolean overdue;

    public GitlabChartIssue(GitlabIssue issue, GitlabProject gitlabProject) {
        this.id = issue.getId();
        this.iid = issue.getIid();
        this.projectId = issue.getProjectId();
        this.title = issue.getTitle();
        this.state = issue.getState();
        this.startDate = issue.getCreatedAt();
        this.closedDate = issue.getClosedAt();
        this.overdue = this.isIssueOverdue(issue);
        this.endDate = this.closedDate == null ? new Date() : this.closedDate;
        this.webUrl = gitlabProject != null ? gitlabProject.getWebUrl() + "/-/issues/" + issue.getIid() : null;
    }

    private boolean isIssueOverdue(GitlabIssue issue) {
        Date closedDate = issue.getClosedAt();
        if (issue.getDueDate() != null) {
            return closedDate != null ? issue.getDueDate().before(closedDate) : issue.getDueDate().before(new Date());
        }
        if (closedDate != null && issue.getMilestone() != null && issue.getMilestone().getDueDate() != null) {
            return issue.getMilestone().getDueDate().before(closedDate);
        }
        return false;
    }

    @Generated
    public GitlabChartIssue() {
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public int getIid() {
        return this.iid;
    }

    @Generated
    public int getProjectId() {
        return this.projectId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public Date getStartDate() {
        return this.startDate;
    }

    @Generated
    public Date getEndDate() {
        return this.endDate;
    }

    @Generated
    public Date getClosedDate() {
        return this.closedDate;
    }

    @Generated
    public String getWebUrl() {
        return this.webUrl;
    }

    @Generated
    public boolean isOverdue() {
        return this.overdue;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setIid(int iid) {
        this.iid = iid;
    }

    @Generated
    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @Generated
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Generated
    public void setClosedDate(Date closedDate) {
        this.closedDate = closedDate;
    }

    @Generated
    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    @Generated
    public void setOverdue(boolean overdue) {
        this.overdue = overdue;
    }
}

