/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.beans.apiwrapper;

import at.rumpelcoders.confluence.beans.apiwrapper.GitlabUser;
import at.rumpelcoders.confluence.beans.model.GitlabNote;
import at.rumpelcoders.confluence.utils.MarkdownToHTML;
import java.util.Date;

public class Note
implements Comparable<Note> {
    private final Long id;
    private final String body;
    private final String attachment;
    private final GitlabUser author;
    private final boolean system;
    private final boolean upvote;
    private final boolean downvote;
    private final Date createdAt;

    public Note(Long id, String body, String attachment, GitlabUser author, boolean system, boolean upvote, boolean downvote, Date createdAt) {
        this.id = id;
        this.body = body;
        this.attachment = attachment;
        this.author = author;
        this.system = system;
        this.upvote = upvote;
        this.downvote = downvote;
        this.createdAt = createdAt;
    }

    public Note(GitlabNote gitlabNote) {
        this.id = gitlabNote.getId();
        if (gitlabNote.getBody() != null) {
            String body = MarkdownToHTML.toHTML(gitlabNote.getBody());
            if (body == null) {
                body = gitlabNote.getBody();
            }
            this.body = body;
        } else {
            this.body = "";
        }
        this.attachment = gitlabNote.getAttachment();
        this.author = gitlabNote.getAuthor() != null ? new GitlabUser(gitlabNote.getAuthor()) : null;
        this.system = gitlabNote.isSystem();
        this.downvote = gitlabNote.isDownvote();
        this.upvote = gitlabNote.isUpvote();
        this.createdAt = gitlabNote.getCreatedAt();
    }

    public Long getId() {
        return this.id;
    }

    public String getBody() {
        return this.body;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public GitlabUser getAuthor() {
        return this.author;
    }

    public boolean isSystem() {
        return this.system;
    }

    public boolean isUpvote() {
        return this.upvote;
    }

    public boolean isDownvote() {
        return this.downvote;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public int compareTo(Note note) {
        if (this.getId() == null || note == null || note.getId() == null) {
            return 0;
        }
        return this.getId().compareTo(note.getId());
    }
}

