/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.beans.apiwrapper;

import at.rumpelcoders.confluence.beans.apiwrapper.GitlabMilestone;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabUser;
import java.lang.reflect.Field;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import lombok.Generated;

public class GitlabIssue {
    private int id;
    private int iid;
    private int projectId;
    private String title;
    private String description;
    private List<String> labels;
    private GitlabMilestone milestone;
    private GitlabUser assignee;
    private GitlabUser author;
    private String state;
    private Date updatedAt;
    private Date createdAt;
    private Date closedAt;
    private Date dueDate;

    public GitlabIssue(org.gitlab.api.models.GitlabIssue issue) {
        this.id = issue.getId();
        this.iid = issue.getIid();
        this.projectId = issue.getProjectId();
        this.title = issue.getTitle();
        this.description = issue.getDescription();
        this.labels = issue.getLabels() != null ? Arrays.asList(issue.getLabels()) : new ArrayList();
        this.milestone = issue.getMilestone() != null ? new GitlabMilestone(issue.getMilestone()) : null;
        this.assignee = issue.getAssignee() != null ? new GitlabUser(issue.getAssignee()) : null;
        this.author = issue.getAuthor() != null ? new GitlabUser(issue.getAuthor()) : null;
        this.state = issue.getState();
        this.updatedAt = issue.getUpdatedAt();
        this.createdAt = issue.getCreatedAt();
        this.dueDate = issue.getDueDate() != null ? Date.from(issue.getDueDate().atStartOfDay(ZoneId.systemDefault()).toInstant()) : null;
        try {
            Date closedDate;
            Field closedDateField = org.gitlab.api.models.GitlabIssue.class.getDeclaredField("closedAt");
            closedDateField.setAccessible(true);
            this.closedAt = closedDate = (Date)closedDateField.get(issue);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.closedAt = null;
        }
    }

    public static org.gitlab.api.models.GitlabIssue convertToLibModel(GitlabIssue issue) {
        org.gitlab.api.models.GitlabIssue iss = new org.gitlab.api.models.GitlabIssue();
        iss.setProjectId(issue.getProjectId());
        iss.setId(issue.getId());
        iss.setIid(issue.getIid());
        return iss;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public int getIid() {
        return this.iid;
    }

    @Generated
    public int getProjectId() {
        return this.projectId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public GitlabMilestone getMilestone() {
        return this.milestone;
    }

    @Generated
    public GitlabUser getAssignee() {
        return this.assignee;
    }

    @Generated
    public GitlabUser getAuthor() {
        return this.author;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getClosedAt() {
        return this.closedAt;
    }

    @Generated
    public Date getDueDate() {
        return this.dueDate;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setIid(int iid) {
        this.iid = iid;
    }

    @Generated
    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Generated
    public void setMilestone(GitlabMilestone milestone) {
        this.milestone = milestone;
    }

    @Generated
    public void setAssignee(GitlabUser assignee) {
        this.assignee = assignee;
    }

    @Generated
    public void setAuthor(GitlabUser author) {
        this.author = author;
    }

    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setClosedAt(Date closedAt) {
        this.closedAt = closedAt;
    }

    @Generated
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }
}

