/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.beans;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import lombok.Generated;

public class IssueFilterBuilder {
    public static final int MAX_ENTRIES = 300;
    public static final int DEFAULT_ENTRIES = 100;
    private int maximumEntries;
    private String label;
    private String state;
    private String orderBy;
    private String sort;
    private String fromDate;
    private String toDate;

    public IssueFilterBuilder(int maximumEntries) {
        this.maximumEntries = maximumEntries;
    }

    public IssueFilterBuilder() {
        this.label = null;
        this.orderBy = null;
        this.state = null;
        this.sort = null;
        this.maximumEntries = 100;
    }

    public IssueFilterBuilder setLabel(String label) {
        if (label != null && !label.replaceAll("\\s+", "").isEmpty()) {
            this.label = label;
        }
        return this;
    }

    public IssueFilterBuilder setMaximumEntries(int maximumEntries) {
        if (maximumEntries > 0 && maximumEntries < 300) {
            this.maximumEntries = maximumEntries;
        }
        return this;
    }

    public StringBuilder build(String baseQuery, int page) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.label != null && !this.label.trim().isEmpty()) {
            parameters.put("labels", URLEncoder.encode(this.label.trim(), StandardCharsets.UTF_8.displayName()));
        }
        if (this.state != null && !this.state.trim().isEmpty()) {
            parameters.put("state", URLEncoder.encode(this.state.trim(), StandardCharsets.UTF_8.displayName()));
        }
        if (this.orderBy != null && !this.orderBy.trim().isEmpty()) {
            this.orderBy = this.orderBy.trim().equals("UpdatedAt") ? "updated_at" : "created_at";
            parameters.put("order_by", this.orderBy);
        }
        if (this.sort != null && !this.sort.trim().isEmpty()) {
            this.sort = this.sort.trim().equals("Ascending") ? "asc" : "desc";
            parameters.put("sort", this.sort);
        }
        if (this.fromDate != null && !this.fromDate.trim().isEmpty()) {
            parameters.put("created_after", this.convertDateToISO8601(this.fromDate));
        }
        if (this.toDate != null && !this.toDate.trim().isEmpty()) {
            parameters.put("created_before", this.convertDateToISO8601(this.toDate));
        }
        int entriesPerPage = this.maximumEntries > 0 && this.maximumEntries < 100 ? this.maximumEntries : 100;
        parameters.put("per_page", String.format("%s", entriesPerPage));
        parameters.put("page", String.format("%s", page));
        StringBuilder tailUrl = new StringBuilder(baseQuery);
        boolean first = true;
        for (String key : parameters.keySet()) {
            String value = (String)parameters.get(key);
            value = value == null ? "" : value;
            String separator = "&";
            if (first) {
                separator = "?";
                first = false;
            }
            tailUrl.append(String.format("%s%s=%s", separator, key, value));
        }
        return tailUrl;
    }

    public String convertDateToISO8601(String dateString) {
        if (dateString == null || dateString.trim().isEmpty()) {
            return null;
        }
        dateString = URLDecoder.decode(dateString.trim(), StandardCharsets.UTF_8.displayName());
        try {
            DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
            LocalDate date = LocalDate.parse(dateString, inputFormatter);
            LocalDateTime dateTime = date.atStartOfDay();
            ZonedDateTime zonedDateTime = dateTime.atZone(ZoneOffset.UTC);
            return zonedDateTime.format(DateTimeFormatter.ISO_INSTANT);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    @Generated
    public IssueFilterBuilder setState(String state) {
        this.state = state;
        return this;
    }

    @Generated
    public IssueFilterBuilder setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    @Generated
    public IssueFilterBuilder setSort(String sort) {
        this.sort = sort;
        return this;
    }

    @Generated
    public IssueFilterBuilder setFromDate(String fromDate) {
        this.fromDate = fromDate;
        return this;
    }

    @Generated
    public IssueFilterBuilder setToDate(String toDate) {
        this.toDate = toDate;
        return this;
    }

    @Generated
    public int getMaximumEntries() {
        return this.maximumEntries;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public String getOrderBy() {
        return this.orderBy;
    }

    @Generated
    public String getSort() {
        return this.sort;
    }

    @Generated
    public String getFromDate() {
        return this.fromDate;
    }

    @Generated
    public String getToDate() {
        return this.toDate;
    }
}

