/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.emoji.Emoji;
import net.sourceforge.plantuml.klimt.creole.command.HtmlCommand;
import net.sourceforge.plantuml.klimt.creole.command.HtmlCommandFactory;
import net.sourceforge.plantuml.klimt.creole.command.PlainText;
import net.sourceforge.plantuml.klimt.font.FontStyle;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;

public class Splitter {
    static final String endFontPattern = "\\</font\\>|\\</color\\>|\\</size\\>|\\</text\\>";
    static final String endSupSub = "\\</sup\\>|\\</sub\\>";
    public static final String fontPattern = "\\<font(\\s+size[%s]*=[%s]*[%g]?\\d+[%g]?|[%s]+color[%s]*=\\s*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>";
    public static final String fontColorPattern2 = "\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>";
    public static final String fontSizePattern2 = "\\<size[\\s:]+(\\d+)[%s]*\\>";
    static final String fontSup = "\\<sup\\>";
    static final String fontSub = "\\<sub\\>";
    public static final String qrcodePattern = "\\<qrcode[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>";
    static final String imgPattern = "\\<img\\s+(src[%s]*=[%s]*[%q%g]?[^\\s%g>]+[%q%g]?[%s]*|vspace\\s*=\\s*[%q%g]?\\d+[%q%g]?\\s*|valign[%s]*=[%s]*[%q%g]?(top|middle|bottom)[%q%g]?[%s]*)+\\>";
    public static final String imgPatternNoSrcColon = "\\<img[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>";
    public static final String fontFamilyPattern = "\\<font[\\s:]+([^>]+)/?\\>";
    public static final String svgAttributePattern = "\\<text[\\s:]+([^>]+)/?\\>";
    private static final String scale2 = "((?:\\{scale=|\\*)[0-9.]+\\}?)?";
    private static final String scale = "([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?";
    public static final String emojiPattern = Emoji.pattern();
    public static final String openiconPattern = "\\<&([-\\w]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?\\>";
    public static final String spritePattern2 = "\\<\\$([-\\p{L}0-9_/]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?\\>";
    public static final String spritePatternForMatch = "\\<\\$([-\\p{L}0-9_/]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?\\>";
    static final String htmlTag;
    static final String linkPattern = "\\[\\[([^\\[\\]]+)\\]\\]";
    public static final String mathPattern = "\\<math\\>(.+?)\\</math\\>";
    public static final String latexPattern = "\\<latex\\>(.+?)\\</latex\\>";
    private static final Pattern2 tagOrText;
    private final List<String> splitted = new ArrayList<String>();

    public Splitter(String s2) {
        Matcher2 matcher = tagOrText.matcher(s2);
        while (matcher.find()) {
            String part = matcher.group(0);
            part = StringUtils.showComparatorCharacters(part);
            this.splitted.add(part);
        }
    }

    List<String> getSplittedInternal() {
        return this.splitted;
    }

    public static String purgeAllTag(String s2) {
        return s2.replaceAll(htmlTag, "");
    }

    public List<HtmlCommand> getHtmlCommands(boolean newLineAlone) {
        HtmlCommandFactory factory = new HtmlCommandFactory();
        ArrayList<HtmlCommand> result = new ArrayList<HtmlCommand>();
        for (String s2 : this.getSplittedInternal()) {
            HtmlCommand cmd = factory.getHtmlCommand(s2);
            if (newLineAlone && cmd instanceof PlainText) {
                result.addAll(this.splitText((PlainText)cmd));
                continue;
            }
            result.add(cmd);
        }
        return Collections.unmodifiableList(result);
    }

    private Collection<PlainText> splitText(PlainText cmd) {
        String s2 = cmd.getText();
        ArrayList<PlainText> result = new ArrayList<PlainText>();
        while (true) {
            int x;
            if ((x = s2.indexOf(PlainText.TEXT_BS_BS_N.getText())) == -1) {
                result.add(new PlainText(s2));
                return result;
            }
            if (x > 0) {
                result.add(new PlainText(s2.substring(0, x)));
            }
            result.add(PlainText.TEXT_BS_BS_N);
            s2 = s2.substring(x + 2);
        }
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (FontStyle style : EnumSet.allOf(FontStyle.class)) {
            sb.append(style.getActivationPattern());
            sb.append('|');
            sb.append(style.getDeactivationPattern());
            sb.append('|');
        }
        sb.append(fontPattern);
        sb.append('|');
        sb.append(fontColorPattern2);
        sb.append('|');
        sb.append(fontSizePattern2);
        sb.append('|');
        sb.append(fontSup);
        sb.append('|');
        sb.append(fontSub);
        sb.append('|');
        sb.append(endFontPattern);
        sb.append('|');
        sb.append(endSupSub);
        sb.append('|');
        sb.append(qrcodePattern);
        sb.append('|');
        sb.append(imgPattern);
        sb.append('|');
        sb.append(imgPatternNoSrcColon);
        sb.append('|');
        sb.append(fontFamilyPattern);
        sb.append('|');
        sb.append(linkPattern);
        sb.append('|');
        sb.append(svgAttributePattern);
        htmlTag = sb.toString();
        tagOrText = MyPattern.cmpile(htmlTag + "|.+?(?=" + htmlTag + ")|.+$");
    }
}

