/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.format.NumberFormat;
import com.vladsch.flexmark.util.misc.Utils;

public class FormattedCounter {
    private final NumberFormat numberFormat;
    private final Boolean isLowercase;
    private final String delimiter;
    private int count;

    public FormattedCounter(NumberFormat format, Boolean lowercase, String delimiter) {
        this.numberFormat = format;
        this.isLowercase = lowercase;
        this.delimiter = delimiter;
        this.reset();
    }

    public void reset() {
        this.count = 0;
    }

    public int getCount() {
        return this.count;
    }

    public int nextCount() {
        return ++this.count;
    }

    public String getFormatted(boolean withDelimiter) {
        String s2 = NumberFormat.getFormat(this.numberFormat, Utils.minLimit(this.count, 1));
        String o = this.isLowercase == null ? s2 : (this.isLowercase != false ? s2.toLowerCase() : s2.toUpperCase());
        return withDelimiter && this.delimiter != null && !this.delimiter.isEmpty() ? o + this.delimiter : o;
    }
}

