/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.statistics;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyStatisticsCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropertyStatisticsCollector.class);

    public void collect(Map<String, Object> stats, String property, Object value) {
        if (stats == null) {
            log.info("Target statistics object is null");
            return;
        }
        if (((String)property).startsWith("get")) {
            property = ((String)property).substring(3);
            property = Character.toLowerCase(((String)property).charAt(0)) + ((String)property).substring(1);
        }
        try {
            Object propValue = PropertyUtils.getProperty(value, (String)property);
            if (propValue instanceof Enum) {
                this.collectEnum(stats, (String)property, (Enum)propValue);
            } else if (propValue instanceof Collection) {
                this.collectCollection(stats, (String)property, (Collection)propValue);
            } else if (propValue instanceof Boolean) {
                this.collectBoolean(stats, (String)property, (Boolean)propValue);
            } else if (propValue instanceof String) {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)propValue))) {
                    this.collectProperty(stats, (String)property);
                }
            } else if (propValue != null) {
                this.collectProperty(stats, (String)property);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void collectProperty(Map<String, Object> stats, String property) {
        stats.compute(property, (prop, count) -> {
            if (!(count instanceof Integer)) {
                count = 0;
            }
            return (Integer)count + 1;
        });
    }

    private void collectBoolean(Map<String, Object> stats, String property, Boolean value) {
        if (value == null || !value.booleanValue()) {
            return;
        }
        this.collectProperty(stats, property);
    }

    private void collectEnum(Map<String, Object> stats, String property, Enum<?> value) {
        if (value == null) {
            return;
        }
        stats.compute(property, (prop, counts) -> {
            if (!(counts instanceof Map)) {
                counts = new LinkedHashMap();
            }
            this.collectProperty((Map<String, Object>)counts, String.valueOf(value));
            return counts;
        });
    }

    private void collectCollection(Map<String, Object> stats, String property, Collection<?> values) {
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        stats.compute(property, (prop, counts) -> {
            if (!(counts instanceof Map)) {
                counts = new LinkedHashMap();
            }
            for (Object value : values) {
                this.collectProperty((Map<String, Object>)counts, String.valueOf(value));
            }
            return counts;
        });
    }
}

