/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.rest;

import com.moveworkforward.license.LicenseInfoProvider;
import com.moveworkforward.model.AbstractGlobalSettings;
import com.moveworkforward.service.GlobalSettingsService;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;

public class AbstractGlobalSettingsController<T extends AbstractGlobalSettings> {
    protected static final boolean CHECK_PERMISSIONS = true;
    protected final GlobalSettingsService<T> globalSettingsService;
    protected final LicenseInfoProvider licenseInfoProvider;

    public AbstractGlobalSettingsController(GlobalSettingsService<T> globalSettingsService, LicenseInfoProvider licenseInfoProvider) {
        this.globalSettingsService = globalSettingsService;
        this.licenseInfoProvider = licenseInfoProvider;
    }

    @GET
    public T get() {
        T globalSettings = this.globalSettingsService.get(true);
        this.enhanceData(globalSettings);
        return globalSettings;
    }

    @POST
    public T save(T globalSettings) {
        globalSettings = this.globalSettingsService.save(globalSettings, true);
        this.enhanceData(globalSettings);
        return globalSettings;
    }

    @DELETE
    public T delete() {
        return this.globalSettingsService.delete(true);
    }

    protected void enhanceData(T globalSettings) {
        Map<String, Object> properties = ((AbstractGlobalSettings)globalSettings).getLicenseInfo();
        Map<String, Object> licenseInfo = this.licenseInfoProvider.getLicenseInfo();
        properties.put("datacenter", licenseInfo.get("Data Center"));
        properties.put("maximumUsers", licenseInfo.get("Maximum Number of Users"));
        properties.put("unlimited", licenseInfo.get("Unlimited Edition"));
    }
}

