/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.utils;

import at.rumpelcoders.confluence.mermaid.MermaidMacroExtension;
import at.rumpelcoders.confluence.plantuml.PlantUmlCodeMacroExtension;
import com.vladsch.flexmark.ext.anchorlink.AnchorLinkExtension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.data.NullableDataKey;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.node.Node;
import org.commonmark.renderer.html.HtmlRenderer;

public class MarkdownToHTML {
    public static String toHTML(String markdownString) {
        if (StringUtils.isBlank((CharSequence)markdownString)) {
            return "";
        }
        org.commonmark.parser.Parser parser = org.commonmark.parser.Parser.builder().build();
        Node document = parser.parse(markdownString);
        HtmlRenderer renderer = HtmlRenderer.builder().build();
        return renderer.render(document).trim();
    }

    public static String convertMarkdownToHtml(String content) {
        MutableDataSet options = new MutableDataSet();
        options.set((DataKey)Parser.EXTENSIONS, (Object)Arrays.asList(AutolinkExtension.create(), TablesExtension.create(), AnchorLinkExtension.create(), TocExtension.create(), WikiLinkExtension.create(), StrikethroughExtension.create(), PlantUmlCodeMacroExtension.create(), TaskListExtension.create(), MermaidMacroExtension.create()));
        options.set((DataKey)Parser.TRACK_DOCUMENT_LINES, (Object)true);
        options.set((DataKey)Parser.WWW_AUTO_LINK_ELEMENT, (Object)true);
        options.set((DataKey)com.vladsch.flexmark.html.HtmlRenderer.SOFT_BREAK, (Object)"<br />\n");
        options.set((DataKey)TablesExtension.MIN_SEPARATOR_DASHES, (Object)2);
        options.set((DataKey)TocExtension.LEVELS, (Object)6);
        options.set((DataKey)TocExtension.DIV_CLASS, (Object)"toc-container");
        options.set((NullableDataKey)TocExtension.TITLE, (Object)"Contents");
        Parser parser = Parser.builder(options).build();
        com.vladsch.flexmark.html.HtmlRenderer renderer = com.vladsch.flexmark.html.HtmlRenderer.builder(options).build();
        Document document = parser.parse(content);
        return renderer.render(document);
    }
}

