/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.resources;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitLabApiException;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.MilestonesFilterBuilder;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabBranch;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabMilestone;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabRelease;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabSnippet;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.resources.AbstractGitLabResource;
import at.rumpelcoders.confluence.resources.AnnotatedNameValuePair;
import at.rumpelcoders.confluence.resources.StringPair;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ConcurrentReferenceHashMap;

@Named(value="projectsResource")
@Path(value="/projects")
public class ProjectsResource
extends AbstractGitLabResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectsResource.class);
    public static final long CACHE_TIMEOUT = 180000L;
    public static final int DEFAULT_RECORD_COUNT = 20;
    private final ConcurrentReferenceHashMap<String, Pair<Long, List<GitlabSnippet>>> projectSnippets = new ConcurrentReferenceHashMap();

    @Inject
    public ProjectsResource(ConfigurationManager configurationManager, GitlabApi gitlabApi) {
        super(configurationManager, gitlabApi);
    }

    @GET
    @Path(value="/branches/search")
    @Produces(value={"application/json"})
    public Response searchBranches(@QueryParam(value="text") String text, @QueryParam(value="projectId") String projectIdString, @QueryParam(value="baseUrl") String baseUrl) {
        GitlabConnection gitlabConnection = this.getConnection(baseUrl);
        try {
            if (StringUtils.isBlank((CharSequence)projectIdString)) {
                GenericEntity<List<String>> entity = new GenericEntity<List<String>>(Collections.emptyList()){};
                return Response.ok((Object)entity).build();
            }
            String projectId = URLEncoder.encode(URLDecoder.decode(projectIdString, StandardCharsets.UTF_8.displayName()), StandardCharsets.UTF_8.displayName());
            List branches = this.gitlabApi.searchBranches(gitlabConnection, (Serializable)((Object)projectId), 20, text).stream().map(GitlabBranch::getName).collect(Collectors.toList());
            List<String> resultBranches = new ArrayList<String>();
            if (StringUtils.isBlank((CharSequence)text) || "default".contains(text)) {
                resultBranches.add("default");
                resultBranches.addAll(branches);
            } else {
                resultBranches = branches;
            }
            GenericEntity<List<String>> entity = new GenericEntity<List<String>>(resultBranches){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fetching branches for project " + projectIdString, (Throwable)e);
            return Response.serverError().status(500).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response getProjectById(@QueryParam(value="projectId") String projectIdString, @QueryParam(value="baseUrl") String baseUrl) {
        GitlabConnection gitlabConnection = this.getConnection(baseUrl);
        try {
            if (StringUtils.isBlank((CharSequence)projectIdString)) {
                List<GitlabProject> projects = this.gitlabApi.getProjects(gitlabConnection, 300, false);
                List resourceProjects = projects.stream().map(p -> new AnnotatedNameValuePair(p.getNameWithNamespace(), p.getId().intValue())).collect(Collectors.toList());
                GenericEntity<List<AnnotatedNameValuePair>> entity = new GenericEntity<List<AnnotatedNameValuePair>>(resourceProjects){};
                return Response.ok((Object)entity).build();
            }
            String projectId = URLDecoder.decode(projectIdString, StandardCharsets.UTF_8.displayName());
            GitlabProject gitlabProject = this.gitlabApi.getProject(gitlabConnection, (Serializable)((Object)projectId), false);
            AnnotatedNameValuePair resourceProject = new AnnotatedNameValuePair(gitlabProject.getName(), gitlabProject.getId().intValue(), gitlabProject.getNameWithNamespace());
            GenericEntity<AnnotatedNameValuePair> entity = new GenericEntity<AnnotatedNameValuePair>(resourceProject){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fetching projects from gitlab");
            return Response.serverError().status(500).build();
        }
    }

    @GET
    @Path(value="/milestones/search")
    @Produces(value={"application/json"})
    public Response getProjectMilestonesByTitle(@QueryParam(value="projectId") String projectIdString, @QueryParam(value="baseUrl") String baseUrl, @QueryParam(value="text") String text) {
        try {
            String projectId = URLDecoder.decode(projectIdString, StandardCharsets.UTF_8.displayName());
            GitlabConnection connection = this.getConnection(baseUrl);
            if (StringUtils.isBlank((CharSequence)connection.getUrl()) || StringUtils.isBlank((CharSequence)connection.getApiKey())) {
                throw new RuntimeException("GitLab is not configured");
            }
            MilestonesFilterBuilder filterBuilder = new MilestonesFilterBuilder().setSearch(text).setMaximumEntries(300);
            List<GitlabMilestone> milestones = this.gitlabApi.getMilestones(connection, (Serializable)((Object)projectId), filterBuilder);
            List resources = milestones.stream().map(p -> new AnnotatedNameValuePair(p.getTitle(), p.getIid())).collect(Collectors.toList());
            GenericEntity<List<AnnotatedNameValuePair>> entity = new GenericEntity<List<AnnotatedNameValuePair>>(resources){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fetching milestones from gitlab", (Throwable)e);
            return Response.serverError().entity((Object)e.getCause().getMessage()).status(500).build();
        }
        catch (Exception e) {
            log.error("error on fetching milestones from gitlab", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(500).build();
        }
    }

    @GET
    @Path(value="/snippets/search")
    @Produces(value={"application/json"})
    public Response getProjectSnippetsByTitle(@QueryParam(value="projectId") String projectIdString, @QueryParam(value="baseUrl") String baseUrl, @QueryParam(value="text") String text) {
        try {
            String projectId = URLDecoder.decode(projectIdString, StandardCharsets.UTF_8.displayName());
            GitlabConnection gitlabConnection = this.getConnection(baseUrl);
            if (StringUtils.isBlank((CharSequence)gitlabConnection.getUrl()) || StringUtils.isBlank((CharSequence)gitlabConnection.getApiKey())) {
                throw new RuntimeException("GitLab is not configured");
            }
            List<Object> result = new ArrayList();
            if (!StringUtils.isBlank((CharSequence)text)) {
                this.cleanUpSnippets();
                Pair data = (Pair)this.projectSnippets.get((Object)projectId);
                List<GitlabSnippet> snippets = null;
                if (data == null) {
                    snippets = this.gitlabApi.getProjectSnippets(gitlabConnection, (Serializable)((Object)projectId));
                    this.projectSnippets.put((Object)projectId, (Object)ImmutablePair.of((Object)System.currentTimeMillis(), snippets));
                } else {
                    snippets = (List<GitlabSnippet>)data.getRight();
                }
                result = snippets.stream().filter(snippet -> snippet.getTitle().toLowerCase().contains(text.toLowerCase())).map(p -> new AnnotatedNameValuePair(p.getTitle(), p.getId())).collect(Collectors.toList());
            }
            GenericEntity<List<AnnotatedNameValuePair>> entity = new GenericEntity<List<AnnotatedNameValuePair>>(result){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fetching project snippets from gitlab", (Throwable)e);
            return Response.serverError().entity((Object)e.getCause().getMessage()).status(500).build();
        }
        catch (Exception e) {
            log.error("error on fetching project snippets from gitlab", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(500).build();
        }
    }

    private void cleanUpSnippets() {
        long now = System.currentTimeMillis();
        this.projectSnippets.values().removeIf(pair -> (Long)pair.getLeft() + 180000L < now);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/releases")
    public Response getReleases(@QueryParam(value="projectId") String projectIdString, @QueryParam(value="baseUrl") String baseUrl) {
        try {
            String projectId = URLDecoder.decode(projectIdString, StandardCharsets.UTF_8.displayName());
            GitlabConnection connection = this.getConnection(baseUrl);
            List<GitlabRelease> releases = this.gitlabApi.getReleases(connection, (Serializable)((Object)projectId));
            List resources = releases.stream().map(p -> new StringPair(p.getTagName(), p.getName())).collect(Collectors.toList());
            GenericEntity<List<StringPair>> entity = new GenericEntity<List<StringPair>>(resources){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fectching issues from gitlab", (Throwable)e);
            return Response.serverError().status(500).build();
        }
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response getProjectsByName(@QueryParam(value="text") String text, @QueryParam(value="baseUrl") String baseUrl) {
        try {
            GitlabConnection gitlabConnection = this.getConnection(baseUrl);
            List<Object> resourceProjects = new ArrayList();
            if (StringUtils.isBlank((CharSequence)gitlabConnection.getUrl()) || StringUtils.isBlank((CharSequence)gitlabConnection.getApiKey())) {
                throw new RuntimeException("GitLab is not configured");
            }
            List<GitlabProject> projects = StringUtils.isBlank((CharSequence)text) ? this.gitlabApi.getProjects(gitlabConnection, 20, false) : this.gitlabApi.searchProjects(gitlabConnection, text);
            resourceProjects = projects.stream().map(p -> new AnnotatedNameValuePair(p.getName(), p.getId().intValue(), p.getNameWithNamespace())).collect(Collectors.toList());
            GenericEntity<List<AnnotatedNameValuePair>> entity = new GenericEntity<List<AnnotatedNameValuePair>>(resourceProjects){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fetching projects from gitlab", (Throwable)e);
            return Response.serverError().entity((Object)e.getCause().getMessage()).status(500).build();
        }
        catch (Exception e) {
            log.error("error on fetching projects from gitlab", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(500).build();
        }
    }
}

