/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitLabApiException;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.IssueFilterBuilder;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabIssue;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import at.rumpelcoders.confluence.beans.apiwrapper.Note;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.macros.BaseGitLabMacro;
import at.rumpelcoders.confluence.utils.MarkdownToHTML;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="issuesMacro")
public class IssuesMacro
extends BaseGitLabMacro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssuesMacro.class);
    public static final String PROJECT_PARAMETER = "project";
    public static final String STATE_PARAMETER = "state";
    public static final String ISSUE_PARAMETER = "issue";
    public static final String LABEL_PARAMETER = "label";
    public static final String SORT_PARAMETER = "sort";
    public static final String ORDERBY_PARAMETER = "orderby";
    public static final String ISSUEID_PARAMTER = "issueid";
    public static final String MAXIMUMENTRIES_PARAMETER = "maximumentries";
    private UserAccessor userAccessor;

    @Inject
    public IssuesMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, @ComponentImport UserAccessor userAccessor, LicenseManager licenseManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport TemplateRenderer renderer) {
        super(gitlabApi, configurationManager, licenseManager, i18nResolver, webResourceUrlProvider, renderer);
        this.userAccessor = userAccessor;
    }

    @Override
    public String doExecute(Map<String, String> parameters, String bodyContent, GitlabConnection connection, ConversionContext conversionContext) throws Exception {
        List<Note> notesForIssue;
        GitlabProject project;
        List<GitlabIssue> issues;
        boolean description;
        block18: {
            String projectId = parameters.get(PROJECT_PARAMETER);
            int issueId = -1;
            Integer iissueId = -1;
            IssueFilterBuilder filterBuilder = new IssueFilterBuilder();
            filterBuilder.setState(parameters.getOrDefault(STATE_PARAMETER, "all"));
            filterBuilder.setLabel(parameters.get(LABEL_PARAMETER));
            filterBuilder.setOrderBy(parameters.getOrDefault(ORDERBY_PARAMETER, "CreatedAt"));
            filterBuilder.setSort(parameters.getOrDefault(SORT_PARAMETER, "Descending"));
            try {
                issueId = Integer.parseInt(parameters.get(ISSUE_PARAMETER));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                iissueId = Integer.parseInt(parameters.get(ISSUEID_PARAMTER));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                filterBuilder.setMaximumEntries(Integer.parseInt(parameters.getOrDefault(MAXIMUMENTRIES_PARAMETER, "100")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            description = Boolean.parseBoolean(parameters.get("showDescription"));
            boolean showComments = Boolean.parseBoolean(parameters.get("showComments"));
            issues = null;
            project = null;
            notesForIssue = null;
            try {
                if (StringUtils.isNotBlank((CharSequence)projectId)) {
                    projectId = URLDecoder.decode(projectId, StandardCharsets.UTF_8.displayName());
                    project = this.gitlabApi.getProject(connection, (Serializable)((Object)projectId), false);
                    if (issueId > 0) {
                        issues = new ArrayList<GitlabIssue>();
                        GitlabIssue issue = this.gitlabApi.getIssue(connection, project.getId(), issueId);
                        issues.add(issue);
                        if (showComments && issue != null) {
                            notesForIssue = this.gitlabApi.getNotesForIssue(connection, issue);
                        }
                    } else if (iissueId > 0) {
                        issues = this.gitlabApi.getIssues(connection, project, iissueId);
                    } else if (issueId == -1) {
                        issues = this.gitlabApi.getIssues(connection, project, filterBuilder);
                    }
                    break block18;
                }
                throw new GitLabApiException(this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.issues-item.no-project-id"));
            }
            catch (Exception e) {
                log.error(String.format("error on fetching issues for key %s", projectId), (Throwable)e);
                throw e;
            }
        }
        if (issues != null) {
            for (GitlabIssue issue : issues) {
                issue.setDescription(MarkdownToHTML.toHTML(issue.getDescription()));
            }
        }
        Map context = MacroUtils.defaultVelocityContext();
        context.put("gitLabUrl", connection.getUrl());
        context.put(PROJECT_PARAMETER, project);
        context.put("detail", description);
        context.put("issues", issues);
        context.put("notesForIssue", notesForIssue);
        if (CollectionUtils.isEmpty(issues)) {
            return this.handleError("No issues are found", parameters);
        }
        return this.render("templates/issues-macro.vm", context);
    }

    @Override
    protected String getMacroErrorPrefix() {
        return this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.issuesmacro.error");
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

