/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.components;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

@Named(value="licenseManager")
public class LicenseManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseManager.class);
    private boolean isDevMode;
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public LicenseManager(@ComponentImport PluginLicenseManager pluginLicenseManager, Environment environment) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.isDevMode = (Boolean)environment.getProperty("moveworkforward.dev.mode", Boolean.class, (Object)false);
    }

    public boolean isLicensed() {
        boolean result = true;
        if (this.isDevMode) {
            log.info("Gitlab API Connector: License check is skipped");
        } else {
            Option license = this.pluginLicenseManager.getLicense();
            boolean bl = result = license.isDefined() && ((PluginLicense)license.get()).isValid();
        }
        if (result) {
            log.info("Gitlab API Connector: Plugin licensed.");
        } else {
            log.error("Gitlab API Connector: There is no valid licence");
        }
        return result;
    }
}

