/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public class RepeatedSequence
implements CharSequence {
    public static RepeatedSequence NULL = new RepeatedSequence(BasedSequence.NULL, 0, 0);
    private final CharSequence chars;
    private final int startIndex;
    private final int endIndex;
    private int hashCode;

    private RepeatedSequence(CharSequence chars, int startIndex, int endIndex) {
        this.chars = chars;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    @Override
    public int length() {
        return this.endIndex - this.startIndex;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.endIndex - this.startIndex) {
            throw new IndexOutOfBoundsException();
        }
        return this.chars.charAt((this.startIndex + index) % this.chars.length());
    }

    @Override
    public CharSequence subSequence(int startIndex, int endIndex) {
        if (startIndex >= 0 && startIndex <= endIndex && endIndex <= this.endIndex - this.startIndex) {
            return startIndex == endIndex ? NULL : (startIndex == this.startIndex && endIndex == this.endIndex ? this : new RepeatedSequence(this.chars, this.startIndex + startIndex, this.startIndex + endIndex));
        }
        throw new IllegalArgumentException("subSequence($startIndex, $endIndex) in RepeatedCharSequence('', " + this.startIndex + ", " + this.endIndex + ")");
    }

    public RepeatedSequence repeat(int count) {
        int endIndex = this.startIndex + (this.endIndex - this.startIndex) * count;
        return this.startIndex >= this.endIndex ? NULL : (this.endIndex == endIndex ? this : new RepeatedSequence(this.chars, this.startIndex, endIndex));
    }

    public int hashCode() {
        int h2 = this.hashCode;
        if (h2 == 0 && this.length() > 0) {
            for (int i = 0; i < this.length(); ++i) {
                h2 = 31 * h2 + this.charAt(i);
            }
            this.hashCode = h2;
        }
        return h2;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharSequence && this.toString().equals(obj.toString());
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this, 0, this.length());
        return sb.toString();
    }

    @NotNull
    public static CharSequence ofSpaces(int count) {
        return new RepeatedSequence(" ", 0, count);
    }

    @NotNull
    public static CharSequence repeatOf(char c, int count) {
        return new RepeatedSequence(String.valueOf(c), 0, count);
    }

    @NotNull
    public static CharSequence repeatOf(@NotNull CharSequence chars, int count) {
        return new RepeatedSequence(chars, 0, chars.length() * count);
    }

    @NotNull
    public static CharSequence repeatOf(@NotNull CharSequence chars, int startIndex, int endIndex) {
        return new RepeatedSequence(chars, startIndex, endIndex);
    }

    @Deprecated
    @NotNull
    public static CharSequence of(char c, int count) {
        return RepeatedSequence.repeatOf(c, count);
    }

    @Deprecated
    @NotNull
    public static CharSequence of(@NotNull CharSequence chars, int count) {
        return RepeatedSequence.repeatOf(chars, count);
    }

    @Deprecated
    @NotNull
    public static CharSequence of(@NotNull CharSequence chars, int startIndex, int endIndex) {
        return RepeatedSequence.repeatOf(chars, startIndex, endIndex);
    }
}

