/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.exception;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.moveworkforward.exception.DetailedException;
import com.moveworkforward.util.MwfPropertyUtils;
import java.util.Arrays;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public abstract class AbstractRestExceptionMapper
implements ExceptionMapper<Exception> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRestExceptionMapper.class);
    @Context
    protected Request request;
    protected boolean isDevMode = false;

    public AbstractRestExceptionMapper(Environment environment) {
        this.isDevMode = MwfPropertyUtils.getInstance().isDevMode(environment);
    }

    public Response toResponse(Exception e) {
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        if (this.isNotFoundException(e)) {
            log.error("Page not found exception", (Throwable)e);
            status = Response.Status.NOT_FOUND;
        } else if (e instanceof WebApplicationException) {
            WebApplicationException webEx = (WebApplicationException)e;
            status = Response.Status.fromStatusCode((int)webEx.getResponse().getStatus());
            if (webEx.getResponse().getStatus() == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
                log.error("Server Error in REST: " + webEx.getResponse().getStatus() + ": " + webEx.getResponse(), (Throwable)e);
            } else {
                log.error("REST response: {}: {}", (Object)webEx.getResponse().getStatus(), (Object)webEx.getResponse());
            }
        } else if (e instanceof DetailedException) {
            log.error("Detailed exception thrown by REST service: " + e.getMessage(), (Throwable)e);
            status = Response.Status.BAD_REQUEST;
        } else {
            log.error("Uncaught exception thrown by REST service: " + e.getMessage(), (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return this.buildResponse(status, new ErrorEntity(e, this.isDevMode));
    }

    protected Response buildResponse(Response.Status status, Object entity) {
        return Response.status((Response.Status)status).entity(entity).build();
    }

    protected abstract boolean isNotFoundException(Exception var1);

    @JsonAutoDetect
    public static class ErrorEntity {
        private String message;
        private Set<DetailedException.ErrorHolder> errors;
        private String[] stackTrace;

        public ErrorEntity(Exception e, boolean printStackTrace) {
            this.message = e.getMessage();
            if (printStackTrace) {
                this.stackTrace = ExceptionUtils.getStackFrames((Throwable)e);
                this.stackTrace = Arrays.copyOf(this.stackTrace, Math.min(this.stackTrace.length, 50));
            }
            if (e instanceof DetailedException) {
                this.errors = ((DetailedException)e).getErrors();
            }
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public Set<DetailedException.ErrorHolder> getErrors() {
            return this.errors;
        }

        @Generated
        public String[] getStackTrace() {
            return this.stackTrace;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public void setErrors(Set<DetailedException.ErrorHolder> errors) {
            this.errors = errors;
        }

        @Generated
        public void setStackTrace(String[] stackTrace) {
            this.stackTrace = stackTrace;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorEntity)) {
                return false;
            }
            ErrorEntity other = (ErrorEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            Set<DetailedException.ErrorHolder> this$errors = this.getErrors();
            Set<DetailedException.ErrorHolder> other$errors = other.getErrors();
            if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
                return false;
            }
            return Arrays.deepEquals(this.getStackTrace(), other.getStackTrace());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ErrorEntity;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            Set<DetailedException.ErrorHolder> $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getStackTrace());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractRestExceptionMapper.ErrorEntity(message=" + this.getMessage() + ", errors=" + this.getErrors() + ", stackTrace=" + Arrays.deepToString(this.getStackTrace()) + ")";
        }
    }
}

