/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.plantuml;

import at.rumpelcoders.confluence.plantuml.PlantUmlCodeMacro;
import at.rumpelcoders.confluence.plantuml.PlantUmlCodeMacroExtension;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.builder.StringSequenceBuilder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlantUmlCodeMacroRenderer
implements NodeRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlantUmlCodeMacroRenderer.class);
    private final String macroName;

    public PlantUmlCodeMacroRenderer(String macroName) {
        this.macroName = macroName;
    }

    @Override
    @Nullable
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<PlantUmlCodeMacro>(PlantUmlCodeMacro.class, this::render));
        return set;
    }

    private void render(PlantUmlCodeMacro node, NodeRendererContext context, HtmlWriter html) {
        StringSequenceBuilder stringSequenceBuilder = StringSequenceBuilder.emptyBuilder();
        stringSequenceBuilder.append("@startuml\n");
        stringSequenceBuilder.append(node.getChars());
        stringSequenceBuilder.append("\n@enduml\n");
        SourceStringReader reader = new SourceStringReader(stringSequenceBuilder.toString());
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            reader.outputImage((OutputStream)os, new FileFormatOption(FileFormat.SVG));
            String svg = new String(os.toByteArray(), StandardCharsets.UTF_8);
            html.raw(svg);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            ((HtmlWriter)((HtmlWriter)html.raw("{")).raw(this.macroName)).raw("}\n");
            html.raw(node.getChars());
            ((HtmlWriter)((HtmlWriter)html.raw("{")).raw(this.macroName)).raw("}\n");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            String macroName = (String)options.getAll().get(PlantUmlCodeMacroExtension.CONFLUENCE_PLANTUML_MACRO);
            if (macroName == null) {
                macroName = PlantUmlCodeMacroExtension.CONFLUENCE_PLANTUML_MACRO.getDefaultValue();
            }
            return new PlantUmlCodeMacroRenderer(macroName);
        }
    }
}

