/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.model;

import at.rumpelcoders.confluence.ao.converters.GlobalSettingsConverter;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.model.LevelRecord;
import at.rumpelcoders.confluence.validation.AdminPermissionConstraint;
import at.rumpelcoders.confluence.validation.SpacesConstraint;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.moveworkforward.v2.ao.Persistence;
import com.moveworkforward.v2.model.IdModel;
import com.moveworkforward.v2.validation.ValidationGroups;
import jakarta.validation.constraints.Positive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect
@AdminPermissionConstraint(groups={ValidationGroups.Save.class, ValidationGroups.Get.class})
@SpacesConstraint(groups={ValidationGroups.Save.class})
@Persistence(entityType="GLOBAL_SETTINGS", converter=GlobalSettingsConverter.class)
public class GlobalSettings
implements IdModel,
Cloneable,
LevelRecord {
    public static final String TYPE = "GLOBAL_SETTINGS";
    public static final int DEFAULT_TIMEOUT_IN_SECONDS = 30;
    private Integer id;
    @Positive
    private int requestTimeout = 30;
    private List<String> allowedSpaces = new ArrayList<String>();
    private List<String> forbiddenSpaces = new ArrayList<String>();
    private boolean autoconversionEnabled = true;

    public boolean isAllowedSpace(String spaceKey) {
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(this.allowedSpaces) && !this.allowedSpaces.contains(spaceKey)) {
            return false;
        }
        return !CollectionUtils.isNotEmpty(this.forbiddenSpaces) || !this.forbiddenSpaces.contains(spaceKey);
    }

    public GlobalSettings clone() {
        GlobalSettings cloned = (GlobalSettings)super.clone();
        cloned.allowedSpaces = new ArrayList(this.allowedSpaces == null ? Collections.emptyList() : this.allowedSpaces);
        cloned.forbiddenSpaces = new ArrayList(this.forbiddenSpaces == null ? Collections.emptyList() : this.forbiddenSpaces);
        return cloned;
    }

    @Override
    public GitLabConfiguration.Level getLevel() {
        return GitLabConfiguration.Level.GLOBAL;
    }

    @Generated
    public GlobalSettings() {
    }

    @Override
    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Generated
    public List<String> getAllowedSpaces() {
        return this.allowedSpaces;
    }

    @Generated
    public List<String> getForbiddenSpaces() {
        return this.forbiddenSpaces;
    }

    @Generated
    public boolean isAutoconversionEnabled() {
        return this.autoconversionEnabled;
    }

    @Override
    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @Generated
    public void setAllowedSpaces(List<String> allowedSpaces) {
        this.allowedSpaces = allowedSpaces;
    }

    @Generated
    public void setForbiddenSpaces(List<String> forbiddenSpaces) {
        this.forbiddenSpaces = forbiddenSpaces;
    }

    @Generated
    public void setAutoconversionEnabled(boolean autoconversionEnabled) {
        this.autoconversionEnabled = autoconversionEnabled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalSettings)) {
            return false;
        }
        GlobalSettings other = (GlobalSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRequestTimeout() != other.getRequestTimeout()) {
            return false;
        }
        if (this.isAutoconversionEnabled() != other.isAutoconversionEnabled()) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List<String> this$allowedSpaces = this.getAllowedSpaces();
        List<String> other$allowedSpaces = other.getAllowedSpaces();
        if (this$allowedSpaces == null ? other$allowedSpaces != null : !((Object)this$allowedSpaces).equals(other$allowedSpaces)) {
            return false;
        }
        List<String> this$forbiddenSpaces = this.getForbiddenSpaces();
        List<String> other$forbiddenSpaces = other.getForbiddenSpaces();
        return !(this$forbiddenSpaces == null ? other$forbiddenSpaces != null : !((Object)this$forbiddenSpaces).equals(other$forbiddenSpaces));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GlobalSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRequestTimeout();
        result = result * 59 + (this.isAutoconversionEnabled() ? 79 : 97);
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List<String> $allowedSpaces = this.getAllowedSpaces();
        result = result * 59 + ($allowedSpaces == null ? 43 : ((Object)$allowedSpaces).hashCode());
        List<String> $forbiddenSpaces = this.getForbiddenSpaces();
        result = result * 59 + ($forbiddenSpaces == null ? 43 : ((Object)$forbiddenSpaces).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GlobalSettings(id=" + this.getId() + ", requestTimeout=" + this.getRequestTimeout() + ", allowedSpaces=" + this.getAllowedSpaces() + ", forbiddenSpaces=" + this.getForbiddenSpaces() + ", autoconversionEnabled=" + this.isAutoconversionEnabled() + ")";
    }
}

