/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.components;

import at.rumpelcoders.confluence.validator.GitLabRecordValidator;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import com.moveworkforward.component.AbstractUserSurveyManager;
import com.moveworkforward.component.TenantIdProvider;
import com.moveworkforward.v2.ao.impl.UserSurveyRepository;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitLabUserSurveyManager
extends AbstractUserSurveyManager
implements TenantIdProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitLabUserSurveyManager.class);
    public static final String SURVEY_ID = "ZQeG8ZUT";
    private static final String PLUGIN_SETTINGS_KEY = "gitlab.plugin.settings";
    private static final String CLIENT_KEY = "azure.client.key";
    private static final String PLUGIN_KEY = "at.rumpelcoders.confluence.gitlab-api";
    private final UserAccessor userAccessor;

    @Autowired
    public GitLabUserSurveyManager(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport PluginAccessor pluginAccessor, UserSurveyRepository userSurveyRepository, GitLabRecordValidator recordValidator, @ComponentImport UserAccessor userAccessor) {
        super(applicationProperties, pluginLicenseManager, pluginSettingsFactory, pluginAccessor, userSurveyRepository, recordValidator);
        this.userAccessor = userAccessor;
    }

    @Override
    protected Optional<String> getUserRole(com.moveworkforward.model.User user) {
        return Optional.ofNullable(user.getUser()).map(o -> this.userAccessor.getGroupNames((User)((ConfluenceUser)user.getUser()))).orElse(Collections.emptyList()).stream().findFirst();
    }

    @Override
    protected Optional<String> getUserEmail(com.moveworkforward.model.User user) {
        return Optional.ofNullable(user.getUser()).map(o -> ((ConfluenceUser)o).getEmail());
    }

    @Override
    protected String getTenantKey() {
        return CLIENT_KEY;
    }

    @Override
    protected String getPluginSettingsKey() {
        return PLUGIN_SETTINGS_KEY;
    }

    @Override
    protected String getPluginKey() {
        return PLUGIN_KEY;
    }

    public static enum SurveyLocation implements AbstractUserSurveyManager.Location
    {
        GLOBAL("global.config"),
        SPACE("space.config"),
        PERSONAL("personal.config"),
        CONTENT("content.config");

        private final String key;

        private SurveyLocation(String key) {
            this.key = key;
        }

        @Override
        @Generated
        public String getKey() {
            return this.key;
        }
    }
}

