/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.beans;

import at.rumpelcoders.confluence.model.GitLabConfiguration;
import lombok.Generated;

public class GitlabConnection {
    private final String url;
    private final String apiKey;
    private final HostType hostType;
    private final int requestTimeout;

    private GitlabConnection(Builder builder) {
        this.url = builder.url;
        this.apiKey = builder.apiKey;
        this.hostType = builder.hostType;
        this.requestTimeout = builder.requestTimeout;
    }

    public boolean isValid() {
        return !this.isNullOrEmpty(this.getApiKey()) && !this.isNullOrEmpty(this.getUrl());
    }

    private boolean isNullOrEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().equals("");
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public HostType getHostType() {
        return this.hostType;
    }

    @Generated
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public static class Builder {
        private String url;
        private String apiKey;
        private HostType hostType;
        private int requestTimeout = 30;

        public Builder config(GitLabConfiguration config, int requestTimeout) {
            return this.url(config.getServerUrl()).apiKey(config.getApiKey()).hostType(config.getHostType()).requestTimeout(requestTimeout > 0 ? requestTimeout : 30);
        }

        public GitlabConnection build() {
            return new GitlabConnection(this);
        }

        @Generated
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public Builder hostType(HostType hostType) {
            this.hostType = hostType;
            return this;
        }

        @Generated
        public Builder requestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }
    }

    public static enum HostType {
        SERVER,
        CLOUD;

    }
}

