/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.service.impl;

import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.component.SendPayloadTask;
import com.moveworkforward.component.ValidationHelper;
import com.moveworkforward.exception.DetailedException;
import com.moveworkforward.model.AbstractGlobalSettings;
import com.moveworkforward.model.AbstractPluginEntity;
import com.moveworkforward.model.AbstractUrlConfiguration;
import com.moveworkforward.model.BaseDestination;
import com.moveworkforward.model.DestinationHolder;
import com.moveworkforward.model.UrlManagement;
import com.moveworkforward.model.UrlTestResponse;
import com.moveworkforward.model.User;
import com.moveworkforward.service.ConfigurationService;
import com.moveworkforward.service.DestinationValidator;
import com.moveworkforward.service.OperationListener;
import com.moveworkforward.service.impl.AbstractConfigurationService;
import com.moveworkforward.service.impl.AbstractGlobalSettingsService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUrlConfigurationService<T extends AbstractUrlConfiguration<?>, K extends BaseDestination>
extends AbstractConfigurationService<T>
implements ConfigurationService<T>,
DestinationValidator<K> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractUrlConfigurationService.class);
    protected final AbstractGlobalSettingsService<? extends AbstractGlobalSettings> globalSettingsService;
    protected final List<ConfigurationService<? extends PluginEntity>> configurationServices;

    public AbstractUrlConfigurationService(PluginRepository pluginRepository, List<OperationListener> operationListeners, ValidationHelper validationHelper, AbstractGlobalSettingsService<? extends AbstractGlobalSettings> globalSettingsService, List<ConfigurationService<? extends PluginEntity>> configurationServices) {
        super(pluginRepository, operationListeners, validationHelper);
        this.globalSettingsService = globalSettingsService;
        this.configurationServices = configurationServices;
        configurationServices.forEach(service -> {
            ValidationHelper helper;
            if (service instanceof AbstractConfigurationService && (helper = ((AbstractConfigurationService)service).getValidationHelper()) != null) {
                helper.setDestinationValidator(this);
            }
        });
        validationHelper.setDestinationValidator(this);
    }

    @Override
    public T delete(int id, boolean checkPermissions) {
        AbstractUrlConfiguration urlConfiguration = (AbstractUrlConfiguration)super.get(id, checkPermissions);
        this.disableConfigurations(urlConfiguration);
        return (T)((AbstractUrlConfiguration)super.delete(id, checkPermissions));
    }

    @Override
    public T save(T urlConfiguration, boolean checkPermissions) {
        if (!((AbstractPluginEntity)(urlConfiguration = (AbstractUrlConfiguration)super.save(urlConfiguration, checkPermissions))).isEnabled()) {
            this.disableConfigurations(urlConfiguration);
        }
        return (T)urlConfiguration;
    }

    @Override
    protected void validate(T configuration) {
        super.validate(configuration);
        AbstractGlobalSettings GlobalSettings2 = this.globalSettingsService.get(false);
        UrlManagement urlManagement = Optional.ofNullable(GlobalSettings2.getUrlManagement()).orElse(new UrlManagement());
        if (!urlManagement.isEnabled()) {
            throw new RuntimeException("Url management is disabled");
        }
        urlManagement.validateUrl(((AbstractUrlConfiguration)configuration).getUrl());
        if (CollectionUtils.isNotEmpty(configuration.getSourceKeys())) {
            configuration.getSourceKeys().forEach(sourceKey -> {
                if (StringUtils.isNotBlank((CharSequence)sourceKey) && !this.validationHelper.isGlobalSourceKey((String)sourceKey) && this.validationHelper.getSourceByKey((String)sourceKey) == null) {
                    throw new IllegalArgumentException("Source is not found by key: " + sourceKey);
                }
            });
        }
        if (!urlManagement.isOnlyManagedUrls()) {
            Collection<String> intersection;
            if (CollectionUtils.isNotEmpty(urlManagement.getExcludedSources()) && !(intersection = CollectionUtils.intersection(urlManagement.getExcludedSources(), configuration.getSourceKeys())).isEmpty()) {
                throw new IllegalArgumentException("URL management is forbidden for sources: " + intersection);
            }
            if (CollectionUtils.isNotEmpty(urlManagement.getExcludedUsers()) && CollectionUtils.isNotEmpty(((AbstractUrlConfiguration)configuration).getUsers())) {
                List configurationUserKeys = ((AbstractUrlConfiguration)configuration).getUsers().stream().map(User::getUserKey).collect(Collectors.toList());
                List excludedUserKeys = urlManagement.getExcludedUsers().stream().map(User::getUserKey).collect(Collectors.toList());
                Collection intersection2 = CollectionUtils.intersection(excludedUserKeys, configurationUserKeys);
                if (!intersection2.isEmpty()) {
                    throw new IllegalArgumentException("URL management is forbidden for users: " + intersection2);
                }
            }
        }
    }

    protected void disableConfigurations(T urlConfiguration) {
        if (urlConfiguration == null) {
            return;
        }
        this.configurationServices.forEach(configurationService -> configurationService.getAll(false).stream().filter((? super T entity) -> entity instanceof DestinationHolder).map(entity -> (DestinationHolder)((Object)entity)).filter(DestinationHolder::isEnabled).filter((? super T x) -> !CollectionUtils.isEmpty(x.getDestinations())).filter((? super T x) -> x.getDestinations().stream().anyMatch(o -> urlConfiguration.getId().equals(o.getUrlId()) && !o.isUseUrl())).forEach(x -> {
            log.warn("Url configuration is being removed. Disabling configuration: type: {} id: {}, name: {}", new Object[]{x.getClass().getName(), ((PluginEntity)((Object)x)).getId(), x.getName()});
            x.setEnabled(false);
            configurationService.save(this.castConfiguration((DestinationHolder<?>)x), false);
        }));
    }

    protected <T extends PluginEntity> T castConfiguration(DestinationHolder<?> config) {
        return (T)((PluginEntity)((Object)config));
    }

    public String resolveUrl(BaseDestination destination) {
        String url;
        if (destination.getUrlId() != null && !destination.isUseUrl()) {
            AbstractUrlConfiguration urlConfiguration = (AbstractUrlConfiguration)this.get(destination.getUrlId(), false);
            if (urlConfiguration == null) {
                log.error("Webhook URL is not found by id: {}", (Object)destination.getUrlId());
                url = null;
            } else {
                url = urlConfiguration.getUrl();
            }
        } else {
            url = destination.getUrl();
        }
        return StringUtils.isBlank((CharSequence)url) ? "" : url;
    }

    @Override
    public void validateDestination(K destination, List<String> sourceKeys, PluginEntity configuration) {
        if (destination == null) {
            throw new DetailedException("Destination is null", "destination");
        }
        AbstractGlobalSettings GlobalSettings2 = this.globalSettingsService.get(false);
        UrlManagement urlManagement = Optional.ofNullable(GlobalSettings2 == null ? null : GlobalSettings2.getUrlManagement()).orElse(new UrlManagement());
        if (!urlManagement.isEnabled() && !((BaseDestination)destination).isUseUrl()) {
            throw new DetailedException("Url management is disabled", "destinations.useUrl");
        }
        if (urlManagement.isEnabled() && urlManagement.isOnlyManagedUrls() && ((BaseDestination)destination).isUseUrl()) {
            throw new DetailedException("Only predefined URLs can be used", "destinations.useUrl");
        }
        if (urlManagement.isEnabled() && !((BaseDestination)destination).isUseUrl()) {
            if (!urlManagement.isOnlyManagedUrls()) {
                Collection<String> intersection;
                List excludedUserKeys;
                User user = this.validationHelper.getCurrentUser();
                if (CollectionUtils.isNotEmpty(urlManagement.getExcludedUsers()) && (excludedUserKeys = urlManagement.getExcludedUsers().stream().map(User::getUserKey).collect(Collectors.toList())).contains(user.getUserKey())) {
                    throw new IllegalArgumentException("Url management is forbidden for user: " + user.getUserKey());
                }
                if (CollectionUtils.isNotEmpty(urlManagement.getExcludedSources()) && CollectionUtils.isNotEmpty(sourceKeys) && !(intersection = CollectionUtils.intersection(urlManagement.getExcludedSources(), sourceKeys)).isEmpty()) {
                    throw new DetailedException("URL management is forbidden for sources: " + intersection, "sources");
                }
            }
            if (((BaseDestination)destination).getUrlId() == null) {
                throw new DetailedException("URL Id is not set", "destinations.urlId");
            }
            try {
                if (this.get(((BaseDestination)destination).getUrlId(), false) == null) {
                    throw new DetailedException("URL configuration is not found by id: " + ((BaseDestination)destination).getUrlId(), "destinations.urlId");
                }
            }
            catch (Exception e) {
                throw new DetailedException("URL configuration can not found by id: " + ((BaseDestination)destination).getUrlId(), "destinations.urlId");
            }
        }
        if (((BaseDestination)destination).isUseUrl()) {
            String url = ((BaseDestination)destination).getUrl();
            urlManagement.validateUrl(url);
        }
    }

    public List<T> getConfigurationsForSettings(String sourceKey) {
        log.debug("Get URL configurations for settings, source {}", (Object)sourceKey);
        User user = this.validationHelper.getCurrentUser();
        if (StringUtils.isBlank((CharSequence)sourceKey) || this.validationHelper.isGlobalSourceKey(sourceKey)) {
            if (!this.validationHelper.isGlobalAdmin(user)) {
                log.error("User[key={}}] is not global admin", (Object)user.getUserKey());
                throw new IllegalArgumentException("User doesn't have permissions");
            }
        } else if (!this.validationHelper.isSourceAdmin(this.validationHelper.getSourceByKey(sourceKey), user)) {
            throw new IllegalArgumentException("User doesn't have permissions");
        }
        if (this.isUrlManagementForbidden(user.getUserKey(), null)) {
            return Collections.emptyList();
        }
        List configurations = this.getAll(true);
        if (StringUtils.isNotBlank((CharSequence)sourceKey)) {
            configurations = configurations.stream().filter((? super T urlConfiguration) -> this.validationHelper.isSourceLevel(urlConfiguration, sourceKey)).collect(Collectors.toList());
        }
        log.debug("URL configurations for settings count: {}", (Object)configurations.size());
        return this.enhanceConfigurations(configurations, true);
    }

    public List<T> getPersonalConfigurations(String userKey) {
        if (StringUtils.isEmpty((CharSequence)userKey)) {
            log.debug("User key is not set, user logged user");
            User user = this.validationHelper.getCurrentUser();
            userKey = user.getUserKey();
        }
        log.debug("Get personal URL configuration for user: {}", (Object)userKey);
        if (this.isUrlManagementForbidden(userKey, null)) {
            return Collections.emptyList();
        }
        List configurations = this.getAll(true);
        String finalUserKey = userKey;
        configurations = configurations.stream().filter(this.validationHelper::isPersonalLevel).filter((? super T c) -> c.getOwner() != null && finalUserKey.equals(c.getOwner().getUserKey())).collect(Collectors.toList());
        log.debug("Personal URL configurations count: {}", (Object)configurations.size());
        return this.enhanceConfigurations(configurations, true);
    }

    public List<T> getConfigurationsForSuggestion(String sourceKey) {
        User user = this.validationHelper.getCurrentUser();
        log.debug("Get URL configuration for suggestion, source {}, user: {}", (Object)sourceKey, (Object)user.getUserKey());
        if (this.isUrlManagementForbidden(user.getUserKey(), sourceKey) || StringUtils.isNotBlank((CharSequence)sourceKey) && !this.validationHelper.hasSourceReadPermissions(sourceKey, user)) {
            return Collections.emptyList();
        }
        List configurations = this.getAll(true);
        if (!this.validationHelper.isGlobalAdmin(user)) {
            configurations = configurations.stream().filter((? super T urlConfiguration) -> this.validationHelper.isSourceLevel(urlConfiguration, sourceKey)).filter((? super T urlConfiguration) -> !this.validationHelper.isPersonalLevel(urlConfiguration) || this.validationHelper.isOwner(urlConfiguration, user)).collect(Collectors.toList());
        }
        log.debug("URL configurations for suggestion count: {}", (Object)configurations.size());
        return this.enhanceConfigurations(configurations, true);
    }

    public UrlTestResponse testUrl(BaseDestination urlTestHolder, boolean showDetails) {
        User user = this.validationHelper.getCurrentUser();
        log.warn("Test URL is called by user: '{}'", (Object)user.getDisplayName());
        if (this.isUrlManagementForbidden(user.getUserKey(), null)) {
            return new UrlTestResponse(UrlTestResponse.Status.FAILED, "URL Management is forbidden");
        }
        if (urlTestHolder == null) {
            return new UrlTestResponse(UrlTestResponse.Status.FAILED, "Nothing to test");
        }
        if (urlTestHolder.isUseUrl() && StringUtils.isBlank((CharSequence)urlTestHolder.getUrl())) {
            return new UrlTestResponse(UrlTestResponse.Status.FAILED, "URL is not specified");
        }
        if (!(urlTestHolder.isUseUrl() || urlTestHolder.getUrlId() != null && urlTestHolder.getUrlId() != 0)) {
            return new UrlTestResponse(UrlTestResponse.Status.FAILED, "URL id is not specified");
        }
        try {
            log.debug("Test URL: {}", (Object)urlTestHolder.getUrl());
            String payload = this.createTestPayload();
            log.debug("Payload: {}", (Object)payload);
            Integer responseCode = null;
            try {
                String url = this.resolveUrl(urlTestHolder);
                responseCode = new SendPayloadTask(payload, url).sendMessage(true, SendPayloadTask.Method.POST);
                if (responseCode >= 300) {
                    throw new RuntimeException("Unexpected response code: " + responseCode);
                }
                return new UrlTestResponse(UrlTestResponse.Status.SUCCESS, null, null);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (showDetails) {
                    String command = String.format("curl -X POST '%s' -d '%s'", urlTestHolder.getUrl(), payload);
                    return new UrlTestResponse(UrlTestResponse.Status.FAILED, responseCode, e.getMessage(), command);
                }
                return new UrlTestResponse(UrlTestResponse.Status.FAILED, "Test failed");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new UrlTestResponse(UrlTestResponse.Status.FAILED, e.getMessage());
        }
    }

    protected abstract String createTestPayload();

    protected boolean isUrlManagementForbidden(String userKey, String sourceKey) {
        List excludedUserKeys;
        AbstractGlobalSettings GlobalSettings2 = this.globalSettingsService.get(false);
        UrlManagement urlManagement = Optional.ofNullable(GlobalSettings2.getUrlManagement()).orElse(new UrlManagement());
        if (!urlManagement.isEnabled()) {
            log.warn("Url management is disabled");
            return true;
        }
        if (urlManagement.isOnlyManagedUrls()) {
            log.warn("Only Url management is allowed");
            return false;
        }
        if (CollectionUtils.isNotEmpty(urlManagement.getExcludedUsers()) && StringUtils.isNotBlank((CharSequence)userKey) && (excludedUserKeys = urlManagement.getExcludedUsers().stream().map(User::getUserKey).collect(Collectors.toList())).contains(userKey)) {
            log.warn("Url management is forbidden for user: " + userKey);
            return true;
        }
        if (CollectionUtils.isNotEmpty(urlManagement.getExcludedSources()) && StringUtils.isNotBlank((CharSequence)sourceKey) && !this.validationHelper.isGlobalSourceKey(sourceKey) && urlManagement.getExcludedSources().contains(sourceKey)) {
            log.warn("URL management is forbidden for source: " + sourceKey);
            return true;
        }
        log.debug("URL management is allowed for user: {} and source: {}", (Object)userKey, (Object)sourceKey);
        return false;
    }
}

