/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.service.impl;

import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.component.ValidationHelper;
import com.moveworkforward.exception.DetailedException;
import com.moveworkforward.model.DestinationHolder;
import com.moveworkforward.model.SourcePluginEntity;
import com.moveworkforward.model.User;
import com.moveworkforward.service.ConfigurationService;
import com.moveworkforward.service.OperationListener;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurationService<T extends PluginEntity>
implements ConfigurationService<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigurationService.class);
    protected final PluginRepository<T> pluginRepository;
    private final List<OperationListener> operationListeners;
    protected final ValidationHelper validationHelper;

    public AbstractConfigurationService(PluginRepository<T> pluginRepository, List<OperationListener> operationListeners, ValidationHelper validationHelper) {
        this.pluginRepository = pluginRepository;
        this.operationListeners = operationListeners;
        this.validationHelper = validationHelper;
    }

    @Override
    public T save(T entity, boolean checkPermissions) {
        OperationListener.OperationType operationType;
        this.validate(entity);
        OperationListener.OperationType operationType2 = operationType = entity.getId() == null || entity.getId() == 0 ? OperationListener.OperationType.CREATE : OperationListener.OperationType.UPDATE;
        if (checkPermissions) {
            T existingEntity;
            if (OperationListener.OperationType.UPDATE.equals((Object)operationType) && (existingEntity = this.pluginRepository.get(entity.getId())) != null) {
                this.validationHelper.checkWritePermissions(existingEntity);
            }
            this.validationHelper.checkWritePermissions(entity);
        }
        T result = this.pluginRepository.save(entity);
        this.callOperationListeners(result, operationType);
        return this.enhanceConfiguration(result, checkPermissions);
    }

    protected void callOperationListeners(T result, OperationListener.OperationType operationType) {
        if (CollectionUtils.isNotEmpty(this.operationListeners)) {
            this.operationListeners.forEach(listener -> {
                try {
                    listener.onOperationPerformed(result, operationType);
                }
                catch (Exception e) {
                    log.error("Error during operation {} listener call", listener.getClass(), (Object)e);
                }
            });
        }
    }

    @Override
    public T get(int id, boolean checkPermissions) {
        T entity = this.pluginRepository.get(id);
        if (entity == null) {
            throw new RuntimeException("Record is not found by id: " + id);
        }
        if (checkPermissions) {
            this.validationHelper.checkReadPermissions(entity);
        }
        return this.enhanceConfiguration(entity, checkPermissions);
    }

    @Override
    public T delete(int id, boolean checkPermissions) {
        T entity = this.pluginRepository.get(id);
        if (entity == null) {
            throw new RuntimeException("Record is not found by id: " + id);
        }
        if (checkPermissions) {
            this.validationHelper.checkDeletePermissions(entity);
        }
        T result = this.pluginRepository.delete(id);
        this.callOperationListeners(result, OperationListener.OperationType.DELETE);
        return this.enhanceConfiguration(result, checkPermissions);
    }

    @Override
    public List<T> getAll(boolean checkPermissions) {
        List<T> result = this.pluginRepository.getAll();
        if (checkPermissions) {
            result = this.filter(result);
        }
        return this.enhanceConfigurations(result, checkPermissions);
    }

    @Override
    public T getByKey(String key, boolean checkPermissions) {
        T result = this.pluginRepository.getByKey(key);
        if (checkPermissions) {
            this.validationHelper.checkReadPermissions(result);
        }
        return this.enhanceConfiguration(result, checkPermissions);
    }

    @Override
    public List<T> getByTag(String tag, boolean checkPermissions) {
        List<T> result = this.pluginRepository.getByTag(tag);
        if (checkPermissions) {
            result = this.filter(result);
        }
        return this.enhanceConfigurations(result, checkPermissions);
    }

    protected List<T> enhanceConfigurations(List<T> configurations, boolean perform) {
        if (perform && !CollectionUtils.isEmpty(configurations)) {
            configurations.forEach(configuration -> this.enhanceConfiguration(configuration, perform));
        }
        return configurations;
    }

    protected T enhanceConfiguration(T configuration, boolean perform) {
        if (perform && configuration != null) {
            this.doEnhancement(configuration);
        }
        return configuration;
    }

    protected void doEnhancement(T configuration) {
    }

    protected void validate(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity is null");
        }
        this.validationHelper.validateLevel((PluginEntity)entity);
        if (entity instanceof DestinationHolder && this.validationHelper.getDestinationValidator() != null) {
            List sourceKeys;
            DestinationHolder destinationHolder = (DestinationHolder)entity;
            List<Object> list = sourceKeys = entity instanceof SourcePluginEntity ? ((SourcePluginEntity)entity).getSourceKeys() : Collections.emptyList();
            if (!CollectionUtils.isEmpty(destinationHolder.getDestinations())) {
                destinationHolder.getDestinations().forEach(d -> this.validationHelper.getDestinationValidator().validateDestination(d, sourceKeys, (PluginEntity)entity));
            } else {
                throw new DetailedException("Destinations are empty", "destinations");
            }
        }
    }

    protected List<T> filter(List<T> entities) {
        User user = this.validationHelper.getCurrentUser();
        return entities.stream().filter((? super T t2) -> this.validationHelper.hasReadPermissions(t2, user)).collect(Collectors.toList());
    }

    @Generated
    public ValidationHelper getValidationHelper() {
        return this.validationHelper;
    }
}

