/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.service;

import at.rumpelcoders.confluence.ao.GitLabRepository;
import at.rumpelcoders.confluence.ao.converters.GitLabConfigurationConverter;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.validator.GitLabRecordValidator;
import com.moveworkforward.service.OperationListener;
import com.moveworkforward.v2.service.impl.AbstractConfigurationService;
import jakarta.validation.ConstraintViolationException;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class GitLabConfigurationService
extends AbstractConfigurationService<GitLabConfiguration> {
    public static final String TOKEN_MASK = "********";

    @Inject
    public GitLabConfigurationService(GitLabRepository pluginRepository, GitLabRecordValidator validationHelper, List<OperationListener> operationListeners) {
        super(pluginRepository, validationHelper, operationListeners);
    }

    @Override
    protected void validate(GitLabConfiguration newConfiguration) {
        if (StringUtils.isBlank((CharSequence)newConfiguration.getUserKey())) {
            newConfiguration.setUserKey(this.recordValidator.getCurrentUser().getUserKey());
        }
        super.validate(newConfiguration);
        List<GitLabConfiguration> existingConfigurations = this.getByTag(GitLabConfigurationConverter.getTag(newConfiguration), newConfiguration.getLevel().toString());
        existingConfigurations.forEach(existingConfiguration -> {
            String url;
            String existingUrl;
            if (!existingConfiguration.getId().equals(newConfiguration.getId()) && (existingUrl = StringUtils.isBlank((CharSequence)existingConfiguration.getServerUrl()) ? "" : existingConfiguration.getServerUrl().trim().replaceAll("/$", "")).equals(url = newConfiguration.getServerUrl())) {
                throw new ConstraintViolationException("serverUrl: Configuration with this server URL already exists for this level", null);
            }
        });
        if (TOKEN_MASK.equals(newConfiguration.getApiKey()) && newConfiguration.getId() != null) {
            GitLabConfiguration existingConfiguration2 = this.pluginRepository.get(newConfiguration.getId(), GitLabConfiguration.class);
            newConfiguration.setApiKey(existingConfiguration2.getApiKey());
        }
    }
}

