/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.resources;

import at.rumpelcoders.confluence.components.GitLabUserSurveyManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.service.GitLabConfigurationService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.moveworkforward.component.UserSurveyManager;
import com.moveworkforward.model.User;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PersonalViewConfigurationAction
extends AbstractUserProfileAction {
    private final PermissionManager permissionManager;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final LicenseManager licenseManager;
    private final GitLabConfigurationService configurationService;
    private final UserSurveyManager userSurveyManager;

    public PersonalViewConfigurationAction(@ComponentImport PermissionManager permissionManager, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, LicenseManager licenseManager, GitLabConfigurationService configurationService, UserSurveyManager userSurveyManager) {
        this.permissionManager = permissionManager;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.licenseManager = licenseManager;
        this.configurationService = configurationService;
        this.userSurveyManager = userSurveyManager;
    }

    public Map<String, Object> getSurvey() {
        return this.userSurveyManager.getSurveyData(this.getCurrentUser(), "ZQeG8ZUT", GitLabUserSurveyManager.SurveyLocation.PERSONAL);
    }

    protected User getCurrentUser() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return new User(confluenceUser, confluenceUser.getKey().getStringValue(), confluenceUser.getName());
    }

    public List<GitLabConfiguration> getConfigurations() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        List<GitLabConfiguration> configurations = this.configurationService.getByTag(user.getKey().getStringValue(), GitLabConfiguration.Level.PERSONAL.toString());
        configurations = configurations.stream().map(c -> {
            GitLabConfiguration configuration;
            configuration.setApiKey((configuration = c.clone()).getApiKey() == null ? "" : "********");
            configuration.setServerUrl(configuration.getServerUrl() == null ? "" : configuration.getServerUrl());
            configuration.setLevel(GitLabConfiguration.Level.PERSONAL);
            configuration.setUserKey(user.getName());
            return configuration;
        }).collect(Collectors.toList());
        return configurations;
    }

    public boolean isLicenseValid() {
        return this.licenseManager.isLicensed();
    }

    public String getBaseUrl() {
        return this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE);
    }

    public String execute() {
        return "success";
    }
}

