/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.resources;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitLabApiException;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.service.GitLabConfigurationService;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.gitlab.api.models.GitlabVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/checkconfig")
@Named(value="checkConfigResource")
public class CheckConfigResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckConfigResource.class);
    private final GitlabApi gitlabApi;
    private final GitLabConfigurationService configurationService;

    @Inject
    public CheckConfigResource(GitLabConfigurationService configurationService, GitlabApi gitlabApi) {
        this.configurationService = configurationService;
        this.gitlabApi = gitlabApi;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response test(GitLabConfiguration configuration, @Context HttpServletRequest request) {
        HashMap<String, String> responseData = new HashMap<String, String>();
        Object errorMessage = null;
        try {
            GitlabConnection connection;
            GitLabConfiguration existingConfiguration;
            if ("********".equals(configuration.getApiKey()) && configuration.getId() != null && configuration.getId() != 0 && (existingConfiguration = (GitLabConfiguration)this.configurationService.get(configuration.getId())) != null) {
                configuration.setApiKey(existingConfiguration.getApiKey());
            }
            if ((connection = new GitlabConnection.Builder().config(configuration, 30).build()).isValid()) {
                GitlabVersion version = this.gitlabApi.getVersion(connection);
                responseData.put("gitlab_version", version.getVersion());
            } else {
                errorMessage = "Could not connect to Gitlab API due to invalid configuration";
                log.error("Could not connect to Gitlab API due to invalid configuration");
            }
        }
        catch (GitLabApiException e) {
            errorMessage = e.getCause().getMessage();
            log.error("Error while checking Gitlab connection", (Throwable)e);
            if (e.getCause() instanceof UnknownHostException) {
                errorMessage = "Unknown host." + (String)errorMessage;
            }
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            log.error("Error while checking Gitlab connection", (Throwable)e);
        }
        if (errorMessage != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errorMessage).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(responseData).build();
    }
}

