/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.resources;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.model.GlobalSettings;
import java.util.List;

public abstract class AbstractGitLabResource {
    protected final ConfigurationManager configurationManager;
    protected final GitlabApi gitlabApi;

    public AbstractGitLabResource(ConfigurationManager configurationManager, GitlabApi gitlabApi) {
        this.configurationManager = configurationManager;
        this.gitlabApi = gitlabApi;
    }

    protected GitlabConnection getConnection(String baseUrl) {
        List<GitLabConfiguration> configurations = this.configurationManager.getSuitableConfigurations(baseUrl);
        if (configurations.isEmpty()) {
            throw new IllegalArgumentException("No suitable GitLab configuration found for base URL: " + baseUrl);
        }
        if (configurations.size() > 1) {
            throw new IllegalArgumentException("Multiple GitLab configurations found for base URL: " + baseUrl);
        }
        GlobalSettings globalSettings = this.configurationManager.getGlobalSettings();
        return new GitlabConnection.Builder().config(configurations.get(0), globalSettings.getRequestTimeout()).build();
    }
}

