/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabMergeRequest;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.macros.BaseGitLabMacro;
import at.rumpelcoders.confluence.utils.MarkdownToHTML;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="mergeRequestsMacro")
public class MergeRequestsMacro
extends BaseGitLabMacro {
    public static final String PROJECT_PARAMETER = "project";
    public static final String SHOW_CLOSED_PARAMETER = "showClosed";
    public static final String SHOW_MERGED_PARAMETER = "showMerged";
    public static final String SHOW_DESCRIPTION_PARAMETER = "showDescription";
    public static final String SHOW_COMMENTS_PARAMETER = "showComments";
    public static final String TEMPLATES_MERGEREQUESTS_MACRO = "templates/mergerequests-macro.vm";

    @Inject
    public MergeRequestsMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport TemplateRenderer renderer) {
        super(gitlabApi, configurationManager, licenseManager, i18nResolver, webResourceUrlProvider, renderer);
    }

    @Override
    public String doExecute(Map<String, String> parameters, String bodyContent, GitlabConnection connection, ConversionContext conversionContext) throws Exception {
        List<GitlabMergeRequest> mergeRequests = null;
        GitlabProject project = null;
        String projectId = URLDecoder.decode(parameters.get(PROJECT_PARAMETER), StandardCharsets.UTF_8.displayName());
        boolean showClosed = Boolean.parseBoolean(parameters.get(SHOW_CLOSED_PARAMETER));
        boolean showMerged = Boolean.parseBoolean(parameters.get(SHOW_MERGED_PARAMETER));
        boolean showDescription = Boolean.parseBoolean(parameters.get(SHOW_DESCRIPTION_PARAMETER));
        project = this.gitlabApi.getProject(connection, (Serializable)((Object)projectId), false);
        mergeRequests = this.gitlabApi.getMergeRequestsWithProjectId(connection, project.getId());
        if (showClosed && showMerged) {
            for (GitlabMergeRequest mergeRequest : mergeRequests) {
                mergeRequest.setDescription(MarkdownToHTML.toHTML(mergeRequest.getDescription()));
            }
        } else {
            mergeRequests.removeIf(mr -> {
                if (mr.isClosed()) {
                    return !showClosed;
                }
                if (mr.isMerged()) {
                    return !showMerged;
                }
                mr.setDescription(MarkdownToHTML.toHTML(mr.getDescription()));
                return false;
            });
        }
        Map context = MacroUtils.defaultVelocityContext();
        context.put("gitLabUrl", connection.getUrl());
        context.put("mergeRequests", mergeRequests);
        context.put(PROJECT_PARAMETER, project);
        context.put(SHOW_DESCRIPTION_PARAMETER, showDescription);
        return this.render(TEMPLATES_MERGEREQUESTS_MACRO, context);
    }

    @Override
    protected String getMacroErrorPrefix() {
        return this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.mergerequests.error");
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

