/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitLabApiException;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.macros.BaseGitLabMacro;
import at.rumpelcoders.confluence.utils.AsciiUtil;
import at.rumpelcoders.confluence.utils.MarkdownToHTML;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.gitlab.api.models.GitlabRepositoryFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="fileMacro")
public class FileMacro
extends BaseGitLabMacro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileMacro.class);

    @Inject
    public FileMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport TemplateRenderer renderer) {
        super(gitlabApi, configurationManager, licenseManager, i18nResolver, webResourceUrlProvider, renderer);
    }

    @Override
    public String doExecute(Map<String, String> parameters, String bodyContent, GitlabConnection connection, ConversionContext conversionContext) throws Exception {
        String projectId = parameters.get("project");
        String path = parameters.get("filePath");
        String ref = parameters.get("reference");
        String fileType = "None";
        String type = parameters.get("fileType");
        if (type != null) {
            fileType = type.equals("Mark Down") ? "MarkDown" : type;
        } else if (parameters.containsKey("isMarkDown") && Boolean.parseBoolean(parameters.get("isMarkDown"))) {
            fileType = "MarkDown";
        }
        boolean showOnlyContent = Boolean.parseBoolean(parameters.get("showOnlyContent"));
        boolean hideContent = Boolean.parseBoolean(parameters.get("hideContent"));
        String fileName = parameters.get("fileName");
        GitlabRepositoryFile gitlabRepositoryFile = null;
        GitlabProject gitlabProject = null;
        try {
            if (!StringUtils.isNotBlank((CharSequence)projectId)) {
                throw new GitLabApiException(this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.issues-item.no-project-id"));
            }
            projectId = URLDecoder.decode(projectId, StandardCharsets.UTF_8.displayName());
            gitlabProject = this.gitlabApi.getProject(connection, (Serializable)((Object)projectId), false);
            ref = ref == null ? gitlabProject.getDefaultBranch() : ref;
            gitlabRepositoryFile = this.gitlabApi.getRepositoryFile(connection, gitlabProject.getId(), path, ref);
        }
        catch (Exception e) {
            log.error(String.format("error on fetching file content for key %s", projectId), (Throwable)e);
            throw e;
        }
        Map context = MacroUtils.defaultVelocityContext();
        context.put("gitLabUrl", connection.getUrl());
        if (gitlabRepositoryFile != null) {
            String content = gitlabRepositoryFile.getContent();
            content = new String(DatatypeConverter.parseBase64Binary((String)content), StandardCharsets.UTF_8);
            if ("MarkDown".equals(fileType)) {
                content = MarkdownToHTML.convertMarkdownToHtml(content);
            } else if ("Ascii".equals(fileType)) {
                content = this.prepareAsciiContent(content);
            }
            context.put("content", content);
            context.put("showOnlyContent", showOnlyContent);
            context.put("hideContent", hideContent);
            context.put("path", StringUtils.isBlank((CharSequence)fileName) ? gitlabRepositoryFile.getFileName() : fileName);
            context.put("uniqueId", UUID.randomUUID().toString());
            context.put("fileType", fileType);
            context.put("lineCount", content.split("\n").length);
            context.put("url", String.format("%s/-/blob/%s/%s", gitlabProject.getWebUrl(), gitlabRepositoryFile.getRef(), gitlabRepositoryFile.getFilePath()));
            context.put("projectName", gitlabProject.getName());
            context.put("projectUrl", gitlabProject.getWebUrl());
            context.put("branch", gitlabRepositoryFile.getRef());
            context.put("branchUrl", String.format("%s/-/tree/%s?ref_type=heads", gitlabProject.getWebUrl(), gitlabRepositoryFile.getRef()));
        }
        return this.render("templates/file-macro.vm", context);
    }

    protected String prepareAsciiContent(String content) {
        AsciiUtil asciiUtil = new AsciiUtil();
        String result = asciiUtil.preparePlantUmlContent(content);
        return asciiUtil.prepareMermaidContent(result);
    }

    @Override
    protected String getMacroErrorPrefix() {
        return this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.filemacro.error");
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

