/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.components;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import javax.inject.Inject;
import lombok.Generated;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.constraints.URL;
import org.hibernate.validator.constraintvalidators.RegexpURLValidator;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ValidationConfiguration
implements DisposableBean {
    private static ValidatorFactory validatorFactory;
    private static Validator validator;

    @Inject
    public ValidationConfiguration(AutowireCapableBeanFactory atlassianBeanFactory) {
        HibernateValidatorConfiguration config = (HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).messageInterpolator(new ParameterMessageInterpolator());
        ConstraintMapping constraintMapping = ((HibernateValidatorConfiguration)config.constraintValidatorFactory(new SpringConstraintValidatorFactory(atlassianBeanFactory))).createConstraintMapping();
        constraintMapping.constraintDefinition(URL.class).includeExistingValidators(false).validatedBy(RegexpURLValidator.class);
        config.addMapping(constraintMapping);
        validatorFactory = config.buildValidatorFactory();
        validator = validatorFactory.getValidator();
    }

    public void destroy() throws Exception {
        if (validatorFactory != null) {
            validatorFactory.close();
        }
    }

    @Generated
    public static Validator getValidator() {
        return validator;
    }

    public static class SpringConstraintValidatorFactory
    implements ConstraintValidatorFactory {
        private final AutowireCapableBeanFactory beanFactory;

        public SpringConstraintValidatorFactory(AutowireCapableBeanFactory beanFactory) {
            Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
            this.beanFactory = beanFactory;
        }

        @Override
        public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
            return (T)((ConstraintValidator)this.beanFactory.createBean(key));
        }

        @Override
        public void releaseInstance(ConstraintValidator<?, ?> instance) {
            this.beanFactory.destroyBean(instance);
        }
    }
}

