/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.beans;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MilestonesFilterBuilder {
    private int maximumEntries = 300;
    private String search;
    private String state;
    private List<Integer> iIds;

    public String build(String baseQuery, int page) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)this.state) && !"all".equalsIgnoreCase(this.state)) {
            parameters.put("state", URLEncoder.encode(this.state.trim(), StandardCharsets.UTF_8.displayName()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.search)) {
            parameters.put("search", URLEncoder.encode(this.search.trim(), StandardCharsets.UTF_8.displayName()));
        }
        if (CollectionUtils.isNotEmpty(this.iIds)) {
            for (Integer iId : this.iIds) {
                if (iId == null) continue;
                parameters.put("iids[]", String.valueOf(iId));
            }
        }
        int entriesPerPage = this.maximumEntries > 0 && this.maximumEntries < 300 ? this.maximumEntries : 300;
        parameters.put("per_page", String.format("%s", entriesPerPage));
        parameters.put("page", String.format("%s", page));
        StringBuilder tailUrl = new StringBuilder(baseQuery);
        boolean first = true;
        for (String key : parameters.keySet()) {
            String value = (String)parameters.get(key);
            String separator = "&";
            if (first) {
                separator = "?";
                first = false;
            }
            tailUrl.append(String.format("%s%s=%s", separator, key, value));
        }
        return tailUrl.toString();
    }

    @Generated
    public int getMaximumEntries() {
        return this.maximumEntries;
    }

    @Generated
    public String getSearch() {
        return this.search;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public List<Integer> getIIds() {
        return this.iIds;
    }

    @Generated
    public MilestonesFilterBuilder setMaximumEntries(int maximumEntries) {
        this.maximumEntries = maximumEntries;
        return this;
    }

    @Generated
    public MilestonesFilterBuilder setSearch(String search) {
        this.search = search;
        return this;
    }

    @Generated
    public MilestonesFilterBuilder setState(String state) {
        this.state = state;
        return this;
    }

    @Generated
    public MilestonesFilterBuilder setIIds(List<Integer> iIds) {
        this.iIds = iIds;
        return this;
    }
}

