/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.ao.migration;

import at.rumpelcoders.confluence.model.GlobalSettings;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moveworkforward.ao.entity.PluginSettingEntity;
import com.moveworkforward.util.ConnectorUtil;
import com.moveworkforward.v2.ao.impl.AbstractPluginRepository;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpgradeTask3
implements ActiveObjectsUpgradeTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask3.class);
    private final ObjectMapper objectMapper = ConnectorUtil.createObjectMapper();
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public UpgradeTask3(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"3");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        Query query = Query.select().where("TYPE = ? AND TAG = ?", new Object[]{"GITLAB_CONFIGURATION", "05f11044-da77-41a8-ac66-a9388ffd0925"}).limit(1);
        PluginSettingEntity[] pluginSettingEntities = (PluginSettingEntity[])activeObjects.find(PluginSettingEntity.class, query);
        if (pluginSettingEntities == null || pluginSettingEntities.length == 0) {
            log.info("No configurations found for migration, skipping upgrade task {}", (Object)this.getModelVersion());
            return;
        }
        try {
            Map map = (Map)this.objectMapper.readValue(pluginSettingEntities[0].getContent(), Map.class);
            GlobalSettings globalSettings = new GlobalSettings();
            globalSettings.setRequestTimeout(this.getRequestTimeout(map));
            globalSettings.setAllowedSpaces(this.getSpaces(map, "allowedSpaces"));
            globalSettings.setForbiddenSpaces(this.getSpaces(map, "forbiddenSpaces"));
            globalSettings.setAutoconversionEnabled(this.getAutoconversionEnabled(map));
            AbstractPluginRepository<PluginSettingEntity> repository = new AbstractPluginRepository<PluginSettingEntity>(activeObjects, this.transactionTemplate){};
            GlobalSettings existingSettings = repository.getByKey("05f11044-da77-41a8-ac66-a9388ffd0925", GlobalSettings.class);
            if (existingSettings != null) {
                globalSettings.setId(existingSettings.getId());
            }
            repository.save(globalSettings);
            log.info("Migration to new DB schema {} has finished", (Object)this.getModelVersion());
        }
        catch (Exception e) {
            log.error("Migration failed", (Throwable)e);
        }
    }

    private List<String> getSpaces(Map<String, Object> map, String name) {
        Object value = map.get(name);
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof String) {
            String[] spaces = ((String)value).split(",");
            return Arrays.asList(spaces);
        }
        return Collections.emptyList();
    }

    private boolean getAutoconversionEnabled(Map<String, Object> map) {
        Object value = map.get("autoconversionEnabled");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    private int getRequestTimeout(Map<String, Object> map) {
        Object value = map.get("requestTimeout");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid request timeout value: {}", value);
            }
        }
        return 30;
    }
}

