AJS.toInit(function () {
    var baseUrl = AJS.$("meta[name='application-base-url']").attr("content");
    var url = AJS.contextPath() + "/rest/rumpelcoders/gitlab-api/1.0/config";
    var checkUrl = AJS.contextPath() + "/rest/rumpelcoders/gitlab-api/1.0/checkconfig";

    AJS.$(".edit-config-button").click(showEditDialog);
    AJS.$("#add-configuration-button").click(showAddDialog);

    spaceSelect($("#allowedSpaces"));
    spaceSelect($("#forbiddenSpaces"));

    function spaceSelect(select) {
        select.mwfSelect2({
            width: "250px",
            ajax: {
                url: function (params) {
                    return AJS.contextPath() + '/rest/api/search?cql=type=space%20and%20space.title~"' + params.term + '*"';
                },
                type: "GET",
                processResults: function (data) {
                    var results = [];
                    for(var i = 0; i < data.results.length; i ++) {
                        var space = data.results[i]["space"];
                        results.push({id: space["key"], text: space["name"]});
                    }
                    return {
                        results: results
                    };
                }
            }
        });
    }

    $("#titles, #urls, #users").mwfSelect2({
        width: "100%",
        allowClear: true,
        placeholder: "Filter by...",
    });

    $("#titles, #urls, #users")
        .on("select2:select", configFilter)
        .on("select2:unselect", configFilter)
        .on("select2:clear", configFilter);

    function configFilter (e) {
        const title = $("#titles").val();
        const url = $("#urls").val();
        const user = $("#users").val();
        if(!title && !url && !user) {
            $("#configs-table").find("tr.data").show();
        }

        $("#configs-table").find("tr.data").each((i, e) => {
            const row = AJS.$(e);
            row.show();
            if(title && row.find(`td[data-value='${title}']`).length === 0) {
                row.hide();
            }
            if(url && row.find(`td[data-value='${url}']`).length === 0) {
                row.hide();
            }
            if(user && row.find(`td[data-value='${user}']`).length === 0) {
                row.hide();
            }
        });
    }

    function saveConfig() {
        var data = {
            id: AJS.$("#id").val(),
            requestTimeout: AJS.$("[name='requestTimeout']").val(),
            allowedSpaces: AJS.$("[name='allowedSpaces']").val(),
            forbiddenSpaces: AJS.$("[name='forbiddenSpaces']").val(),
            autoconversionEnabled: AJS.$("#autoconversionEnabled").is(":checked")
        };
        AJS.$.ajax({
            url: url + "/global-settings",
            type: "POST",
            contentType: "application/json",
            data: JSON.stringify(data)
        }).done(function (data) {
           message("#result-ajax", $('#result-text-success').val(), AJS.messages.success, true);
           AJS.$("#id").val(data["id"]);
        }).fail(function (xhr) {
            message("#result-ajax", xhr.statusText + (": " + xhr.responseText) || "", AJS.messages.error);
        });
    }

    AJS.$(".remove-config-button").click(function () {
        let form = AJS.$("[href='#" + AJS.$(this).closest("div").attr("id") + "']").closest("tr").find("." + AJS.$(this).attr("data-form"));
        if (form.length === 0) {
            form = AJS.$(this).closest("tr").find('form');
        }
        dialogId = form.attr('class') + "-dialog";
        var dialog = new AJS.Dialog({
            width: 300,
            height: 250,
            id: dialogId
        });

        let errorMessage = form.attr('data-submit');
        let httpMethod = form.attr('method');

        if (!errorMessage) {
            errorMessage = 'Are you sure about operation?'
        }

        if(!httpMethod) {
            httpMethod = 'POST';
        }

        dialog.addHeader('Confirm operation');

        dialog.addPanel("Repo", `<div>${errorMessage}</div>`, "");

        dialog.addButton(
            AJS.I18n.getText("at.rumpelcoders.confluence.configuration.ok"),
            function () {
                AJS.$.ajax({
                    url: AJS.contextPath() + form.attr("action"),
                    type: httpMethod,
                    contentType: "application/json"
                }).done(function (data) {
                    location.reload();
                }).fail(function (xhr) {
                    message("#result-ajax", xhr.statusText + (": " + xhr.responseText) || "", AJS.messages.error);
                });
            },
            "aui-button"
        );

        dialog.addCancel(
            AJS.I18n.getText("at.rumpelcoders.confluence.gitlab-api.settings.cancel"),
            function (dialog) {
                dialog.remove();
            }
        );

        dialog.show();
    });

    function preOpenDialogActions(interior) {

    }

    function showAddDialog() {
        var interior = AJS.$("#configuration-container").clone();
        var content = interior.html();
        content = content.replace("<!--", "").replace(/-->\s*$/, "");
        interior.html(content);
        preOpenDialogActions(interior);

        showDialog(interior, "add-configuration-dialog", AJS.I18n.getText("at.rumpelcoders.confluence.configuration.add"));
    }

    function showEditDialog() {
        let dialogId = "edit-config-dialog";
        var interior = AJS.$("#configuration-container").clone();
        var content = interior.html();
        content = content.replace("<!--", "").replace(/-->\s*$/, "");
        interior.html(content);
        let id = AJS.$("[href='#" + AJS.$(this).closest("div").attr("id") + "']").closest("tr").find("[data-val][data-name='id']").attr("data-val");
        var messageContainerId = "#" + dialogId + " .message-container";
        AJS.$.ajax({
            url: `${url}/${id}`,
            type: "GET",
            dataType: "json",
            contentType: "application/json",
            async: false,
            error: function (xhr) {
                AJS.$(".hide-dialog").hide();
                preOpenDialogActions(interior);
                showDialog(interior, dialogId, AJS.I18n.getText("at.rumpelcoders.confluence.configuration.edit"));

                var error = xhr.responseText;
                try {
                    error = jQuery.parseJSON(error)["message"];
                } catch (e) {
                }
                message(messageContainerId,
                    xhr.statusText + (": " + error) || "",
                    AJS.messages.error);
            },
            success: function (response) {
                AJS.$(".hide-dialog").hide();
                mapObjectToForm(response, interior.find("form"))
                prepareEdit(interior)
                preOpenDialogActions(interior);
                showDialog(interior, dialogId, AJS.I18n.getText("at.rumpelcoders.confluence.configuration.edit"));
            }
        });
    }

    function prepareEdit(interior) {
    }

    function mapObjectToForm(config, form) {
        for ([key, value] of Object.entries(config)) {
            var inputs = form.find("[name='" + key + "']");
            if (Array.isArray(value)) {
                inputs = form.find("[name='" + key + "[]']");
            }
            if (inputs.is("select")) {
                if (Array.isArray(value)) {
                    value.forEach(v => {
                        if (inputs.find("option[value='" + v + "']").length === 0) {
                            inputs.append($(`<option value="${v}">${v}</option>`));
                        }
                    });
                } else {
                    if (inputs.find("option[value='" + value + "']").length === 0) {
                        inputs.append($(`<option value="${value}">${value}</option>`));
                    }
                }
                inputs.val(value).change();
            } else if (inputs.is(":radio")) {
                inputs.val([value]).change();
            } else if (inputs.is(":checkbox")) {
                inputs.prop('checked', value);
            } else {
                inputs.val(value).change();
            }
        }
    }

    function showDialog(interior, dialogId, headerText) {
        AJS.$(".hide-dialog").hide();
        var dialog = new AJS.Dialog({
            width: 500,
            height: 500,
            id: dialogId
        });

        dialog.addHeader(headerText);

        dialog.addPanel("Configuration", interior, "");
        interior.show();
        var messageContainerId = "#" + dialogId + " .message-container";

        dialog.addButton(
            AJS.I18n.getText("at.rumpelcoders.confluence.gitlab-api.settings.check"),
            function () {
                AJS.$(".hide-dialog").show();
                var form = interior.find("form");
                let data = serializeFormToObject(form);
                interior.find(".input-error").removeClass("input-error");

                AJS.$.ajax({
                    url: checkUrl,
                    type: "POST",
                    dataType: "json",
                    contentType: "application/json",
                    data: JSON.stringify(data),
                    async: true,
                    error: function (xhr) {
                        AJS.$(".hide-dialog").hide();
                        handleError(xhr, messageContainerId, interior);
                    },
                    success: function () {
                        AJS.$(".hide-dialog").hide();
                        message(messageContainerId,
                            AJS.I18n.getText("at.rumpelcoders.confluence.gitlab-api.settings.check.success"),
                            AJS.messages.success, true);
                    }
                });
            },
            "aui-button"
        );

        dialog.addButton(
            AJS.I18n.getText("at.rumpelcoders.confluence.gitlab-api.settings.save"),
            function () {
                var form = interior.find("form");
                AJS.$(".hide-dialog").show();
                let data = serializeFormToObject(form);
                interior.find(".input-error").removeClass("input-error");

                AJS.$.ajax({
                    url: url,
                    type: "POST",
                    dataType: "json",
                    contentType: "application/json",
                    data: JSON.stringify(data),
                    async: true,
                    error: function (xhr) {
                        AJS.$(".hide-dialog").hide();
                        handleError(xhr, messageContainerId, interior);
                    },
                    success: function (data, status, xhr) {
                        AJS.$(".hide-dialog").hide();
                        dialog.remove();
                        form.get(0).reset();
                        location.reload();
                    }
                });
            },
            "aui-button"
        );

        dialog.addCancel(
            AJS.I18n.getText("at.rumpelcoders.confluence.gitlab-api.settings.cancel"),
            function (dialog) {
                dialog.remove();
            }
        );
        dialog.show();
    }

    function handleError(xhr, messageContainerId, interior) {
        var errorMessage = xhr.responseText;
        try {
            let errorObject = jQuery.parseJSON(errorMessage);
            errorMessage = errorObject["message"];
            if (errorObject["stack-trace"] && errorObject["stack-trace"].indexOf("ConstraintViolationException") > 0) {
                var formattedMessage = "";
                errorMessage.split(",").forEach(part => {
                    let key = part.split(":")[0];
                    let keyMessage = part.split(":")[1];
                    if (typeof key !== 'undefined' && key.trim() !== '') {
                        key = key.trim();
                        interior.find(`#${key}, #${key}-single-select, #${key}-multi-select`).addClass("input-error");
                        var label = interior.find(`label[for='${key}']`).html();
                        if (typeof label !== 'undefined' && label.trim() !== '') {
                            formattedMessage += `${label}: ${keyMessage}<br/>`;
                        }
                    } else {
                        if (keyMessage.indexOf("Wrong or empty access credentials for the given service type") > 0) {
                            interior.find(`#token, #privateKey, #appId`).addClass("input-error");
                        }
                        formattedMessage += `${keyMessage}<br/>`;
                    }
                });
                errorMessage = formattedMessage;
            }
        } catch (e) {
            let index = errorMessage.replaceAll("\n", " ").replaceAll("\t", " ").indexOf(" at");
            if (index > 3) {
                errorMessage = errorMessage.substring(0, index - 3);
            }
        }
        message(messageContainerId,
            xhr.statusText + (": " + errorMessage) || "",
            AJS.messages.error);

    }

    function serializeFormToObject(form) {
        var disabled = form.find(':disabled').prop('disabled', false);
        var data = form.serializeObject();
        form.find("input[type='checkbox']").each((j, ch) => {
            var el = $(ch);
            data[el.attr("name")] = el.attr("checked") === "checked";
        });
        for (const [key, value] of Object.entries(data)) {
            if (Array.isArray(value)) {
                let filtered = value.filter(function (el) {
                    return el != null && el !== "";
                });
                data[key] = filtered;

            } else if (value === "") {
                delete data[key];
            }
        }
        disabled.prop('disabled', true);
        return data;
    }

    function deleteConfig() {
        var id = AJS.$("#id").val();
        if(typeof id === 'undefined' || id === null || id === '') {
            return;
        }

        AJS.$.ajax({
            url: url + "?id=" + id,
            type: "DELETE",
            contentType: "application/json"
        }).done(function (data) {
            location.reload();
        }).fail(function (xhr) {
           message("#result-ajax", xhr.statusText + (": " + xhr.responseText) || "", AJS.messages.error);
        });
    }

    function message(id, text, func, fadeout) {
            AJS.$(id).empty();
            func.apply(AJS.messages, [id, {
                closeable: true,
                fadeout: fadeout,
                body: text
            }]);
        }

    function checkConnection() {
        var data = {
            id: AJS.$("#id").val(),
            serverUrl: AJS.$("#serverUrl").val(),
            apiKey: AJS.$("#apiKey").val(),
            tokenType: AJS.$("[name='tokenType']:checked").val(),
            hostType: AJS.$("[name='hostType']:checked").val(),
            requestTimeout: AJS.$("[name='requestTimeout']").val()
        };
        $('#result-ajax').html('... Checking connection ...');
        AJS.$.ajax({
            url: checkUrl,
            type: "POST",
            contentType: "application/json",
            data: JSON.stringify(data)
        }).done(function (data) {
            var text = $('<p style="color: red"></p>').html($('#result-check-text-error').val());
            console.log(data);
            if(data.hasOwnProperty("connectionOk") && data.connectionOk) {
                text = $('<p style="color: green"></p>').html($('#result-check-text-success').val());
            }
            $('#result-ajax').html(text).fadeOut(3500, resetAfterFadeOut);
        }).fail(function (xhr) {
            $('#result-ajax').html($('#result-check-text-error').val()).fadeOut(3500, resetAfterFadeOut);
        });
    }

    function resetAfterFadeOut() {
        $(this).html('');
        $(this).css('display', 'block');
    }

    AJS.$('#checkConnection').on('click', function(e){
        e.preventDefault();
        checkConnection();
    });

    AJS.$('#deleteConnection').on('click', function(e) {
        e.preventDefault();
        deleteConfig();
    });

    AJS.$("#global-settings-form").submit(function (e) {
        e.preventDefault();
        saveConfig();
    });

    try {
        let surveyData = AJS.$("#surveyData");
        if(surveyData.length > 0) {
            let submitted = false;
            let hidden = {};
            surveyData.find("input").each((i, element) => {
                let el = AJS.$(element);
                hidden[el.attr("name")] = el.val();
            });
            const {open, close, toggle, refresh} = window.tf.createPopup(surveyData.attr('data-val'), {
                mode: 'popup',
                autoClose: true,
                hideHeaders: true,
                hideFooters: true,
                width: "600px",
                height: "400px",
                open: 'time',
                openValue: 20000,
                preventReopenOnClose: true,
                hidden: hidden,
                onSubmit: function () {
                    submitted = true;
                    AJS.$.ajax({
                        url: AJS.contextPath() + '/rest/rumpelcoders/gitlab-api/1.0/survey/submit/' + surveyData.attr('data-val'),
                        type: "POST",
                        dataType: "json",
                        contentType: "application/json",
                        async: true,
                        error: function(xhr) {
                            console.error(xhr.statusText + (": " + xhr.responseText) || "");
                            submitted = false;
                        },
                        success: function(response) {
                            console.log("Survey submitted");
                        }
                    });
                },
                onClose: function () {
                    if(!submitted) {
                        AJS.$.ajax({
                            url: AJS.contextPath() + '/rest/rumpelcoders/gitlab-api/1.0/survey/close/' + surveyData.attr('data-val'),
                            type: "POST",
                            dataType: "json",
                            contentType: "application/json",
                            async: true,
                            error: function(xhr) {
                                console.error(xhr.statusText + (": " + xhr.responseText) || "");
                                submitted = false;
                            },
                            success: function(response) {
                                console.log("Survey closed");
                            }
                        });
                    }
                }
            });
            open();
        }
    } catch (error) {
        console.error(error);
    }

});

