/*
 * Decompiled with CFR 0.152.
 */
package smetana.core.debug;

import gen.annotation.HasND_Rank;
import gen.annotation.Original;
import gen.annotation.Reviewed;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Purify {
    private final Map<String, Method> methods = new LinkedHashMap<String, Method>();
    private final File out2 = new File("../out-smetana", "smetana.txt");
    private PrintWriter pw2;
    private int currentLevel;

    public Purify() {
        try {
            this.out2.getParentFile().mkdirs();
            this.pw2 = new PrintWriter(this.out2);
            System.err.println("CREATING " + this.out2.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    synchronized void logline(String s2) {
        System.err.println(s2);
        if (this.pw2 == null) {
            return;
        }
        this.pw2.println(s2);
        this.pw2.flush();
    }

    public synchronized void entering(String signature, String methodNameDeclared) {
        if (!this.methods.containsKey(signature)) {
            try {
                Method method = this.recordMe(methodNameDeclared);
                this.methods.put(signature, method);
                String key = this.getKey(method);
                if (key.length() > 2 && !key.equals(signature)) {
                    throw new IllegalStateException(signature);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        ++this.currentLevel;
        this.traceCall(this.pw2, signature, methodNameDeclared);
    }

    public synchronized void leaving(String signature, String methodName) {
        --this.currentLevel;
    }

    private void traceCall(PrintWriter pw, String signature, String methodNameDeclared) {
        Method m4 = this.methods.get(signature);
        String line = String.format("(%02d) %-26.26s [%-10.10s] %s", this.currentLevel, signature, this.getReviewedWhen(m4), methodNameDeclared);
        if (pw == null) {
            return;
        }
        pw.println(line);
        pw.flush();
    }

    private synchronized Method recordMe(String methodNameDeclared) throws ClassNotFoundException {
        Throwable creationPoint = new Throwable();
        creationPoint.fillInStackTrace();
        StackTraceElement ste3 = creationPoint.getStackTrace()[3];
        StackTraceElement ste4 = creationPoint.getStackTrace()[4];
        String className = ste3.getClassName();
        String methodName3 = ste3.getMethodName();
        String methodName4 = ste4.getMethodName();
        Class<?> theClass = Class.forName(className);
        Method theMethod3 = this.getTheMethod(theClass, methodName3);
        if (methodNameDeclared.equals(theMethod3.getName())) {
            return theMethod3;
        }
        Method theMethod4 = this.getTheMethod(theClass, methodName4);
        if (this.checkWarning(methodNameDeclared, theMethod3) && methodNameDeclared.equals(theMethod4.getName())) {
            return theMethod4;
        }
        creationPoint.printStackTrace();
        System.exit(0);
        throw new IllegalArgumentException();
    }

    private synchronized boolean checkWarning(String methodNameDeclared, Method theMethod3) {
        if ((methodNameDeclared + "_").equals(theMethod3.getName())) {
            return true;
        }
        return (methodNameDeclared + "_w_").equals(theMethod3.getName());
    }

    private synchronized Method getTheMethod(Class<?> theClass, String methodName2) {
        for (Method method : theClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName2)) continue;
            return method;
        }
        Throwable creationPoint = new Throwable();
        creationPoint.fillInStackTrace();
        creationPoint.printStackTrace();
        System.exit(0);
        throw new IllegalArgumentException();
    }

    public void reset() {
        this.methods.clear();
    }

    public void printMe() {
        ArrayList<Map.Entry<String, Method>> reverse = new ArrayList<Map.Entry<String, Method>>(this.methods.entrySet());
        Collections.reverse(reverse);
        for (Map.Entry entry : reverse) {
            String signature = (String)entry.getKey();
            Method m4 = (Method)entry.getValue();
            String reviewedWhen = this.getReviewedWhen(m4);
            String version = this.getVersion(m4);
            String path = this.getPath(m4);
            String hasND_Rank = this.hasND_Rank(m4) ? "*" : " ";
            System.err.printf("%-8s %-26s %-12s %s %-30s %s%n", version, signature, reviewedWhen, hasND_Rank, m4.getName(), path);
        }
    }

    private String getVersion(Method method) {
        Original original = method.getDeclaredAnnotation(Original.class);
        if (original == null) {
            return "XX";
        }
        return original.version();
    }

    private String getPath(Method method) {
        Original original = method.getDeclaredAnnotation(Original.class);
        if (original == null) {
            return "XX";
        }
        return original.path();
    }

    private String getReviewedWhen(Method method) {
        Reviewed reviewed = method.getDeclaredAnnotation(Reviewed.class);
        if (reviewed == null) {
            return "?";
        }
        return reviewed.when();
    }

    private boolean hasND_Rank(Method method) {
        HasND_Rank reviewed = method.getDeclaredAnnotation(HasND_Rank.class);
        return reviewed != null;
    }

    private String getKey(Method method) {
        Original original = method.getDeclaredAnnotation(Original.class);
        if (original == null) {
            return "?";
        }
        return original.key();
    }
}

