/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection.iteration;

import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Reverse<T>
implements ReversibleIterable<T> {
    @NotNull
    private final List<T> list;
    private final boolean isReversed;

    public Reverse(@NotNull List<T> list) {
        this(list, true);
    }

    public Reverse(@NotNull List<T> list, boolean isReversed) {
        this.list = list;
        this.isReversed = isReversed;
    }

    @Override
    @NotNull
    public ReversibleIterator<T> iterator() {
        return new ReversedListIterator<T>(this.list, this.isReversed);
    }

    @Override
    @NotNull
    public ReversibleIterable<T> reversed() {
        return new Reverse<T>(this.list, !this.isReversed);
    }

    @Override
    public boolean isReversed() {
        return this.isReversed;
    }

    @Override
    @NotNull
    public ReversibleIterator<T> reversedIterator() {
        return new ReversedListIterator<T>(this.list, !this.isReversed);
    }

    static class ReversedListIterator<T>
    implements ReversibleIterator<T> {
        @NotNull
        private final List<T> list;
        private final boolean isReversed;
        private int index;

        ReversedListIterator(@NotNull List<T> list, boolean isReversed) {
            this.list = list;
            this.isReversed = isReversed;
            this.index = isReversed ? (list.size() == 0 ? -1 : list.size() - 1) : (list.size() == 0 ? -1 : 0);
        }

        @Override
        public boolean isReversed() {
            return this.isReversed;
        }

        @Override
        public void remove() {
        }

        @Override
        public boolean hasNext() {
            return this.index != -1;
        }

        @Override
        public T next() {
            T t2 = this.list.get(this.index);
            if (this.index != -1) {
                this.index = this.isReversed ? --this.index : (this.index == this.list.size() - 1 ? -1 : ++this.index);
            }
            return t2;
        }
    }
}

