/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.ast;

import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.data.DataKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeRepository<T>
implements Map<String, T> {
    protected final ArrayList<T> nodeList = new ArrayList();
    protected final Map<String, T> nodeMap = new HashMap<String, T>();
    protected final KeepType keepType;

    @NotNull
    public abstract DataKey<? extends NodeRepository<T>> getDataKey();

    @NotNull
    public abstract DataKey<KeepType> getKeepDataKey();

    @NotNull
    public abstract Set<T> getReferencedElements(Node var1);

    @SafeVarargs
    protected final void visitNodes(@NotNull Node parent, @NotNull Consumer<Node> runnable, Class<? extends Node> ... classes) {
        NodeVisitor visitor = new NodeVisitor();
        for (Class<? extends Node> clazz : classes) {
            visitor.addHandler(new VisitHandler<Node>(clazz, runnable::accept));
        }
        visitor.visit(parent);
    }

    public NodeRepository(@Nullable KeepType keepType) {
        this.keepType = keepType == null ? KeepType.LOCKED : keepType;
    }

    @NotNull
    public String normalizeKey(@NotNull CharSequence key) {
        return key.toString();
    }

    @Nullable
    public T getFromRaw(@NotNull CharSequence rawKey) {
        return this.nodeMap.get(this.normalizeKey(rawKey));
    }

    @Nullable
    public T putRawKey(@NotNull CharSequence key, @NotNull T t2) {
        return this.put(this.normalizeKey(key), t2);
    }

    @NotNull
    public Collection<T> getValues() {
        return this.nodeMap.values();
    }

    public static <T> boolean transferReferences(@NotNull NodeRepository<T> destination, @NotNull NodeRepository<T> included, boolean onlyIfUndefined, @Nullable Map<String, String> referenceIdMap) {
        boolean transferred = false;
        for (Map.Entry<String, T> entry : included.entrySet()) {
            String key = entry.getKey();
            if (referenceIdMap != null) {
                referenceIdMap.getOrDefault(key, key);
            }
            if (onlyIfUndefined && destination.containsKey(key)) continue;
            destination.put(key, entry.getValue());
            transferred = true;
        }
        return transferred;
    }

    @Override
    @Nullable
    public T put(@NotNull String s2, @NotNull T t2) {
        T another;
        this.nodeList.add(t2);
        if (this.keepType == KeepType.LOCKED) {
            throw new IllegalStateException("Not allowed to modify LOCKED repository");
        }
        if (this.keepType != KeepType.LAST && (another = this.nodeMap.get(s2)) != null) {
            if (this.keepType == KeepType.FAIL) {
                throw new IllegalStateException("Duplicate key " + s2);
            }
            return another;
        }
        return this.nodeMap.put(s2, t2);
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends T> map) {
        if (this.keepType == KeepType.LOCKED) {
            throw new IllegalStateException("Not allowed to modify LOCKED repository");
        }
        if (this.keepType != KeepType.LAST) {
            for (String string : map.keySet()) {
                this.nodeMap.put(string, map.get(string));
            }
        } else {
            this.nodeMap.putAll(map);
        }
    }

    @Override
    @Nullable
    public T remove(@NotNull Object o) {
        if (this.keepType == KeepType.LOCKED) {
            throw new IllegalStateException("Not allowed to modify LOCKED repository");
        }
        return this.nodeMap.remove(o);
    }

    @Override
    public void clear() {
        if (this.keepType == KeepType.LOCKED) {
            throw new IllegalStateException("Not allowed to modify LOCKED repository");
        }
        this.nodeMap.clear();
    }

    @Override
    public int size() {
        return this.nodeMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nodeMap.isEmpty();
    }

    @Override
    public boolean containsKey(@NotNull Object o) {
        return this.nodeMap.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.nodeMap.containsValue(o);
    }

    @Override
    @Nullable
    public T get(@NotNull Object o) {
        return this.nodeMap.get(o);
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.nodeMap.keySet();
    }

    @Override
    @NotNull
    public List<T> values() {
        return this.nodeList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, T>> entrySet() {
        return this.nodeMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.nodeMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.nodeMap.hashCode();
    }
}

