/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.v2.validation;

import com.moveworkforward.model.User;
import com.moveworkforward.v2.validation.RecordValidator;
import com.moveworkforward.v2.validation.ValidationGroups;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordValidator
implements RecordValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRecordValidator.class);

    @Override
    public <T> void checkWritePermissions(T target) {
        this.checkPermissions(target, ValidationGroups.Save.class);
    }

    @Override
    public <T> void checkReadPermissions(T target) {
        this.checkPermissions(target, ValidationGroups.Get.class);
    }

    protected <T> void checkPermissions(T target, Class<?> group) {
        Set<ConstraintViolation<T>> violations = this.getValidator().validate(target, group);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public <T> void checkDeletePermissions(T target) {
        this.checkWritePermissions(target);
    }

    protected abstract Validator getValidator();

    @Override
    public abstract User getCurrentUser();

    @Override
    public <T> boolean hasReadPermissions(T target, User user) {
        return this.getValidator().validate(target, ValidationGroups.Get.class).isEmpty();
    }

    @Override
    public <T> void validate(T target) {
        LinkedHashSet<ConstraintViolation<T>> violations = new LinkedHashSet<ConstraintViolation<T>>(this.getValidator().validate(target, new Class[0]));
        violations.addAll(this.getValidator().validate(target, ValidationGroups.Save.class));
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public abstract boolean hasTagPermission(String var1, String var2);
}

