/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.v2.ao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.moveworkforward.ao.entity.PersistenceEntity;
import com.moveworkforward.ao.entity.ReportEntity;
import com.moveworkforward.ao.entity.ReportPersistenceEntity;
import com.moveworkforward.util.DayTimeUtil;
import com.moveworkforward.v2.ao.ScheduledPluginRepository;
import com.moveworkforward.v2.ao.impl.AbstractPluginRepository;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScheduledConfigurationRepository<K extends ReportEntity>
extends AbstractPluginRepository<K>
implements ScheduledPluginRepository<K> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractScheduledConfigurationRepository.class);
    protected TransactionTemplate transactionTemplate;

    public AbstractScheduledConfigurationRepository(ActiveObjects activeObjects, TransactionTemplate transactionTemplate) {
        super(activeObjects, transactionTemplate);
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public <T> List<T> getByDateAndTime(Date date, int hour, int minute, Class<T> clazz) {
        String entityType = AbstractScheduledConfigurationRepository.getType(clazz);
        String dateTimePattern = DayTimeUtil.getDateTimePattern(date, hour, minute);
        return this.getByDateTimePattern(dateTimePattern, entityType, clazz);
    }

    @Override
    public <T> List<T> getByDateAndTime(int day, int hour, int minute, Class<T> clazz) {
        String entityType = AbstractScheduledConfigurationRepository.getType(clazz);
        String dateTimePattern = DayTimeUtil.getDateTimePattern(day, hour, minute);
        return this.getByDateTimePattern(dateTimePattern, entityType, clazz);
    }

    protected <T> List<T> getByDateTimePattern(String dateTimePattern, String entityType, Class<T> clazz) {
        log.debug("Get entities by dateTimePattern: {}, type: {}", (Object)dateTimePattern, (Object)entityType);
        return (List)this.transactionTemplate.execute(() -> {
            Query query = Query.select((String)this.getFields()).where("TYPE = ? AND ENABLED = ? AND REPORT_TIME like ?", new Object[]{entityType, true, dateTimePattern});
            ArrayList result = new ArrayList();
            this.activeObjects.stream(this.persistentClass, query, t2 -> result.add(this.convertFromPersistence(t2, clazz)));
            return result;
        });
    }

    @Override
    protected void updateParams(ReportEntity existingEntity, PersistenceEntity newEntity) {
        existingEntity.setKey(newEntity.getKey());
        existingEntity.setTag(newEntity.getTag());
        existingEntity.setContent(newEntity.getContent());
        existingEntity.setEnabled(((ReportPersistenceEntity)newEntity).isEnabled());
        existingEntity.setReportTime(((ReportPersistenceEntity)newEntity).getReportTime());
    }

    @Override
    protected Map<String, Object> createParams(PersistenceEntity entity) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("TYPE", entity.getType());
        params.put("KEY", entity.getKey());
        params.put("TAG", entity.getTag());
        params.put("CONTENT", entity.getContent());
        params.put("REPORT_TIME", ((ReportPersistenceEntity)entity).getReportTime());
        params.put("ENABLED", ((ReportPersistenceEntity)entity).isEnabled());
        return params;
    }
}

