/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.service.impl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.component.ValidationHelper;
import com.moveworkforward.exception.DetailedException;
import com.moveworkforward.model.AbstractScheduledReportConfiguration;
import com.moveworkforward.model.Delivery;
import com.moveworkforward.model.ScheduledPluginEntity;
import com.moveworkforward.model.TimePeriod;
import com.moveworkforward.service.CallBackReportService;
import com.moveworkforward.service.OperationListener;
import com.moveworkforward.service.ReportService;
import com.moveworkforward.service.impl.AbstractConfigurationService;
import com.moveworkforward.util.DayTimeUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractReportService<T extends ScheduledPluginEntity>
extends AbstractConfigurationService<T>
implements CallBackReportService,
ReportService<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractReportService.class);
    protected final List<CallBackReportService.OperationCallback> configurationCallbacks = new ArrayList<CallBackReportService.OperationCallback>();
    @ComponentImport
    @Autowired
    private TimeZoneManager timeZoneManager;

    public AbstractReportService(PluginRepository<T> repository, List<OperationListener> operationListeners, ValidationHelper validationHelper) {
        super(repository, operationListeners, validationHelper);
    }

    @Override
    public T save(T entity, boolean checkPermissions) {
        ScheduledPluginEntity result = (ScheduledPluginEntity)super.save(entity, checkPermissions);
        this.onSave(result);
        return (T)result;
    }

    @Override
    public void validate(T entity) {
        super.validate(entity);
        this.validateDelivery(entity);
    }

    protected void validateDelivery(T entity) {
        if (entity.getDelivery() == null) {
            throw new DetailedException("Delivery is null", "delivery");
        }
        Delivery delivery = entity.getDelivery();
        if (delivery.isDeliverOnSchedule()) {
            if (AbstractScheduledReportConfiguration.DeliveryFrequency.SCHEDULED.equals((Object)delivery.getFrequency())) {
                if (!this.isDeliveryCanBeScheduled(delivery)) {
                    throw new DetailedException("Execution date is not specified", "delivery.date", "delivery.timePeriod", "delivery.hour", "delivery.minute");
                }
                if (StringUtils.isBlank((CharSequence)delivery.getDate()) && delivery.getTimePeriod() != null) {
                    delivery.setDate(DayTimeUtil.getNextExecutionDate(delivery));
                } else if (StringUtils.isNotBlank((CharSequence)delivery.getDate()) && delivery.getTimePeriod() == null) {
                    delivery.setTimePeriod(this.getTimePeriodBasedOnDate(delivery));
                }
            } else if (delivery.getDay() <= 0 && AbstractScheduledReportConfiguration.DeliveryFrequency.WEEKLY.equals((Object)delivery.getFrequency())) {
                throw new DetailedException("Day is not specified for WEEKLY report", "delivery.day");
            }
        } else {
            if (delivery.getCheckHoursPeriod() <= 0) {
                throw new DetailedException("Period in hours is not set", "delivery.checkHoursPeriod");
            }
            if (delivery.getHour() == null) {
                delivery.setHour(Calendar.getInstance().get(11));
            }
            if (delivery.getMinute() == null) {
                delivery.setMinute(0);
            }
        }
        if (this.timeZoneManager != null) {
            String zoneId = this.timeZoneManager.getDefaultTimeZone().toZoneId().getId();
            delivery.setServerTimeZone(zoneId);
            if (StringUtils.isBlank((CharSequence)delivery.getUserTimeZone())) {
                delivery.setUserTimeZone(zoneId);
            }
        }
    }

    protected boolean isDeliveryCanBeScheduled(Delivery delivery) {
        return StringUtils.isNotBlank((CharSequence)delivery.getDate()) || delivery.getTimePeriod() != null && delivery.getTimePeriod().isSet() || delivery.getHour() != null && delivery.getMinute() != null;
    }

    protected TimePeriod getTimePeriodBasedOnDate(Delivery delivery) {
        TimePeriod timePeriod = null;
        try {
            Date date = DayTimeUtil.DATE_FORMAT.parse(delivery.getDate());
            Period period = Period.fieldDifference((ReadablePartial)new LocalDateTime().withHourOfDay(delivery.getHour().intValue()).withMinuteOfHour(delivery.getMinute().intValue()), (ReadablePartial)LocalDateTime.fromDateFields((Date)date).withHourOfDay(delivery.getHour().intValue()).withMinuteOfHour(delivery.getMinute().intValue()));
            for (TimePeriod.TimeUnit timeUnit : TimePeriod.TimeUnit.values()) {
                int interval = Math.abs(period.get(timeUnit.getDurationFieldType()));
                if (interval <= 0) continue;
                timePeriod = new TimePeriod(interval, timeUnit);
                break;
            }
        }
        catch (ParseException e) {
            throw new DetailedException("Date must match pattern \"yyyy-MM-dd\"", "delivery.date");
        }
        if (timePeriod == null) {
            throw new IllegalArgumentException("'Time period' is not defined");
        }
        return timePeriod;
    }

    protected void onSave(T configuration) {
        try {
            this.configurationCallbacks.parallelStream().forEach(callback -> callback.onSave(configuration));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void addCallBack(CallBackReportService.OperationCallback callback) {
        this.configurationCallbacks.add(callback);
        try {
            callback.onCount(this.pluginRepository.count());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

