/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.service.impl;

import com.google.common.collect.EvictingQueue;
import com.moveworkforward.model.AbstractGlobalSettings;
import com.moveworkforward.model.MessageAudit;
import com.moveworkforward.service.GlobalSettingsService;
import com.moveworkforward.service.MessageAuditService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractMessageAuditService
implements MessageAuditService {
    private final GlobalSettingsService<? extends AbstractGlobalSettings> globalSettingsService;
    protected Queue<MessageAudit> cache = EvictingQueue.create(this.getLimit());

    protected AbstractMessageAuditService(GlobalSettingsService<? extends AbstractGlobalSettings> globalSettingsService) {
        this.globalSettingsService = globalSettingsService;
    }

    @Override
    public synchronized MessageAudit save(MessageAudit entity) {
        boolean checkPermissions = false;
        if (entity != null && this.globalSettingsService.get(checkPermissions).isAuditMessagesEnabled()) {
            entity.setLastModified(new Date());
            this.cache.add(entity);
        }
        return entity;
    }

    @Override
    public synchronized List<MessageAudit> getAll(boolean checkPermissions) {
        if (checkPermissions) {
            return this.filterByUserPermissions(this.cache);
        }
        return new ArrayList<MessageAudit>(this.cache);
    }

    @Override
    public synchronized List<MessageAudit> getByTag(String tag, boolean checkPermissions) {
        List<MessageAudit> result = null;
        result = StringUtils.isBlank((CharSequence)tag) ? new ArrayList<MessageAudit>(this.cache) : this.cache.stream().filter(messageAudit -> tag.equals(messageAudit.getTag())).collect(Collectors.toList());
        if (checkPermissions) {
            return this.filterByUserPermissions(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteAll(boolean checkPermissions) {
        if (checkPermissions) {
            this.hasUserAdminPermissions();
        }
        int count = this.cache.size();
        AbstractMessageAuditService abstractMessageAuditService = this;
        synchronized (abstractMessageAuditService) {
            this.cache.clear();
        }
        return count;
    }

    protected abstract List<MessageAudit> filterByUserPermissions(Collection<MessageAudit> var1);

    protected abstract void hasUserAdminPermissions();

    protected abstract int getLimit();
}

