/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.validator;

import at.rumpelcoders.confluence.components.ValidationConfiguration;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.moveworkforward.v2.validation.AbstractRecordValidator;
import jakarta.validation.Validator;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitLabRecordValidator
extends AbstractRecordValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitLabRecordValidator.class);
    protected final PermissionManager permissionManager;

    @Autowired
    public GitLabRecordValidator(@ComponentImport PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    protected Validator getValidator() {
        return ValidationConfiguration.getValidator();
    }

    @Override
    public com.moveworkforward.model.User getCurrentUser() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return Optional.ofNullable(confluenceUser).map(u -> new com.moveworkforward.model.User(u, u.getKey().getStringValue(), u.getFullName())).orElse(new com.moveworkforward.model.User());
    }

    public boolean isGlobalAdmin(com.moveworkforward.model.User user) {
        return this.permissionManager.isConfluenceAdministrator((User)user.getUser());
    }

    @Override
    public boolean hasTagPermission(String tag, String level) {
        com.moveworkforward.model.User user = this.getCurrentUser();
        if (this.isGlobalAdmin(user)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)tag)) {
            return false;
        }
        if (GitLabConfiguration.Level.PERSONAL.toString().equals(level)) {
            return user.getUserKey().equals(tag);
        }
        return false;
    }
}

