/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.validation;

import at.rumpelcoders.confluence.model.LevelRecord;
import at.rumpelcoders.confluence.validation.AdminPermissionConstraint;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AdminPermissionValidator
implements ConstraintValidator<AdminPermissionConstraint, LevelRecord> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminPermissionValidator.class);
    @ComponentImport
    @Autowired
    private PermissionManager permissionManager;

    public static boolean isGlobalAdmin(PermissionManager permissionManager, ConfluenceUser confluenceUser) {
        return permissionManager.isConfluenceAdministrator((User)confluenceUser);
    }

    @Override
    public boolean isValid(LevelRecord configuration, ConstraintValidatorContext context) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return AdminPermissionValidator.isGlobalAdmin(this.permissionManager, confluenceUser);
    }
}

