/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.servlets;

import at.rumpelcoders.confluence.components.GitLabUserSurveyManager;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.model.GlobalSettings;
import at.rumpelcoders.confluence.service.GitLabConfigurationService;
import at.rumpelcoders.confluence.service.GlobalSettingsService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.component.UserSurveyManager;
import com.moveworkforward.model.User;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="settingsServlet")
public class SettingsServlet
extends HttpServlet {
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer renderer;
    private final SpaceManager spaceManager;
    private final GitLabConfigurationService configurationService;
    private final GlobalSettingsService globalSettingsService;
    private final UserSurveyManager userSurveyManager;

    @Autowired
    public SettingsServlet(@ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer renderer, @ComponentImport SpaceManager spaceManager, GitLabConfigurationService configurationService, GlobalSettingsService globalSettingsService, UserSurveyManager userSurveyManager) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.configurationService = configurationService;
        this.spaceManager = spaceManager;
        this.globalSettingsService = globalSettingsService;
        this.userSurveyManager = userSurveyManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (userkey == null) {
            this.redirectToLogin(request, response);
            return;
        }
        if (!this.userManager.isSystemAdmin(userkey)) {
            response.setStatus(403);
            response.getWriter().write("You don't have permissions");
            response.getWriter().flush();
            return;
        }
        Collection<GitLabConfiguration> configurations = new TreeSet<GitLabConfiguration>(Comparator.comparing(GitLabConfiguration::getLevel).thenComparing(GitLabConfiguration::getId));
        HashMap userNames = new HashMap();
        configurations.addAll(this.configurationService.getAll());
        configurations = configurations.stream().map(c -> {
            GitLabConfiguration configuration;
            configuration.setApiKey((configuration = c.clone()).getApiKey() == null ? "" : "********");
            configuration.setServerUrl(configuration.getServerUrl() == null ? "" : configuration.getServerUrl());
            if (StringUtils.isNotBlank((CharSequence)configuration.getUserKey())) {
                String username = userNames.computeIfAbsent(configuration.getUserKey(), key -> {
                    UserProfile userProfile = this.userManager.getUserProfile(new UserKey(key));
                    return userProfile == null ? "" : userProfile.getUsername();
                });
                configuration.setUserKey(username);
            }
            return configuration;
        }).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet<String> spaceKeys = new LinkedHashSet<String>();
        GlobalSettings globalSettings = this.globalSettingsService.get();
        if (CollectionUtils.isNotEmpty(globalSettings.getAllowedSpaces())) {
            spaceKeys.addAll(globalSettings.getAllowedSpaces());
        }
        if (CollectionUtils.isNotEmpty(globalSettings.getForbiddenSpaces())) {
            spaceKeys.addAll(globalSettings.getForbiddenSpaces());
        }
        HashMap<String, String> usedSpaces = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(spaceKeys)) {
            List spaces = this.spaceManager.getAllSpaces(SpacesQuery.newQuery().withSpaceKeys(spaceKeys).build());
            usedSpaces.putAll(spaces.stream().collect(Collectors.toMap(Space::getKey, Space::getName)));
        }
        Map<String, Object> surveyData = this.userSurveyManager.getSurveyData(this.getCurrentUser(), "ZQeG8ZUT", GitLabUserSurveyManager.SurveyLocation.GLOBAL);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("configurations", configurations);
        parameters.put("globalSettings", globalSettings);
        parameters.put("usedSpaces", usedSpaces);
        if (surveyData != null) {
            parameters.put("survey", surveyData);
        }
        parameters.put("users", configurations.stream().map(GitLabConfiguration::getUserKey).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(TreeSet::new)));
        parameters.put("urls", configurations.stream().map(GitLabConfiguration::getServerUrl).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(TreeSet::new)));
        parameters.put("titles", configurations.stream().map(GitLabConfiguration::getTitle).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(TreeSet::new)));
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/global-settings.vm", parameters, (Writer)response.getWriter());
    }

    private User getCurrentUser() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return new User(confluenceUser, confluenceUser.getKey().getStringValue(), confluenceUser.getName());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

