/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.resources;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitLabApiException;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabIssue;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.resources.AbstractGitLabResource;
import at.rumpelcoders.confluence.resources.AnnotatedNameValuePair;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/projects/issues")
public class IssuesResource
extends AbstractGitLabResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssuesResource.class);

    @Autowired
    public IssuesResource(ConfigurationManager configurationManager, GitlabApi gitlabApi) {
        super(configurationManager, gitlabApi);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getIssueById(@QueryParam(value="projectId") String projectIdString, @QueryParam(value="issueId") String issueIdString, @QueryParam(value="baseUrl") String baseUrl) {
        try {
            String projectId = URLDecoder.decode(projectIdString, StandardCharsets.UTF_8.displayName());
            int issueId = Integer.parseInt(issueIdString);
            GitlabConnection connection = this.getConnection(baseUrl);
            GitlabIssue issue = this.gitlabApi.getIssue(connection, (Serializable)((Object)projectId), issueId);
            AnnotatedNameValuePair resourceProject = new AnnotatedNameValuePair(issue.getTitle(), issue.getId());
            GenericEntity<AnnotatedNameValuePair> entity = new GenericEntity<AnnotatedNameValuePair>(resourceProject){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fectching issues from gitlab", (Throwable)e);
            return Response.serverError().status(500).build();
        }
    }

    @GET
    @Path(value="/labels")
    @Produces(value={"application/json"})
    public Response getIssues(@QueryParam(value="projectId") String projectIdString, @QueryParam(value="label") String label, @QueryParam(value="baseUrl") String baseUrl) {
        try {
            String projectId = URLDecoder.decode(projectIdString, StandardCharsets.UTF_8.displayName());
            GitlabConnection connection = this.getConnection(baseUrl);
            GitlabProject project = this.gitlabApi.getProject(connection, (Serializable)((Object)projectId), false);
            List<GitlabIssue> issues = this.gitlabApi.getIssues(connection, project, new Integer[0]);
            List resources = issues.stream().map(p -> new AnnotatedNameValuePair(p.getTitle(), p.getIid())).collect(Collectors.toList());
            GenericEntity<List<AnnotatedNameValuePair>> entity = new GenericEntity<List<AnnotatedNameValuePair>>(resources){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fectching issues from gitlab", (Throwable)e);
            return Response.serverError().status(500).build();
        }
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response getIssuesByName(@QueryParam(value="projectId") String projectIdString, @QueryParam(value="baseUrl") String baseUrl, @QueryParam(value="text") String text) {
        try {
            String projectId = URLDecoder.decode(projectIdString, StandardCharsets.UTF_8.displayName());
            GitlabConnection connection = this.getConnection(baseUrl);
            if (StringUtils.isBlank((CharSequence)connection.getUrl()) || StringUtils.isBlank((CharSequence)connection.getApiKey())) {
                throw new RuntimeException("GitLab is not configured");
            }
            List<GitlabIssue> issues = this.gitlabApi.searchIssues(connection, (Serializable)((Object)projectId), text);
            List resources = issues.stream().map(p -> new AnnotatedNameValuePair(p.getTitle(), p.getIid())).collect(Collectors.toList());
            GenericEntity<List<AnnotatedNameValuePair>> entity = new GenericEntity<List<AnnotatedNameValuePair>>(resources){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fetching issues from gitlab", (Throwable)e);
            return Response.serverError().entity((Object)e.getCause().getMessage()).status(500).build();
        }
        catch (Exception e) {
            log.error("error on fetching issues from gitlab", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(500).build();
        }
    }
}

