/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.resources;

import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.model.GlobalSettings;
import at.rumpelcoders.confluence.service.GitLabConfigurationService;
import at.rumpelcoders.confluence.service.GlobalSettingsService;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/config")
@Named(value="configResource")
public class ConfigResource {
    private final GitLabConfigurationService configurationService;
    private final GlobalSettingsService globalSettingsService;
    private final ConfigurationManager configurationManager;

    @Autowired
    public ConfigResource(GitLabConfigurationService configurationService, GlobalSettingsService globalSettingsService, ConfigurationManager configurationManager) {
        this.configurationService = configurationService;
        this.globalSettingsService = globalSettingsService;
        this.configurationManager = configurationManager;
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public GitLabConfiguration getConfiguration(@PathParam(value="id") int id) {
        return this.hideKey((GitLabConfiguration)this.configurationService.get(id));
    }

    @POST
    @Path(value="/global-settings")
    @Produces(value={"application/json"})
    public GlobalSettings saveGlobalSettings(GlobalSettings globalSettings) {
        return this.globalSettingsService.save(globalSettings);
    }

    @Path(value="/effective")
    @GET
    @Produces(value={"application/json"})
    public EffectiveSettings getEffectiveSettings() {
        EffectiveSettings settings = new EffectiveSettings();
        settings.setGlobalSettings(this.configurationManager.getGlobalSettings());
        settings.setConfigurations(this.configurationManager.getPossibleConfigurations().stream().map(this::hideKey).collect(Collectors.toList()));
        return settings;
    }

    @GET
    @Produces(value={"application/json"})
    public GitLabConfiguration get(@QueryParam(value="userKey") String userKey) {
        List configurations = StringUtils.isBlank((CharSequence)userKey) ? this.configurationService.getByTag("05f11044-da77-41a8-ac66-a9388ffd0925", GitLabConfiguration.Level.GLOBAL.toString()) : this.configurationService.getByTag(userKey, GitLabConfiguration.Level.PERSONAL.toString());
        GitLabConfiguration result = CollectionUtils.isEmpty(configurations) ? new GitLabConfiguration() : (GitLabConfiguration)configurations.get(0);
        return this.hideKey(result);
    }

    @GET
    @Path(value="checkSpace/{spaceKey}")
    @Produces(value={"application/json"})
    public Response isSpaceAllowed(@PathParam(value="spaceKey") String spaceKey, @Context HttpServletRequest request) {
        GlobalSettings globalSettings = this.configurationManager.getGlobalSettings();
        return Response.ok().entity(ImmutableMap.of("spaceKey", spaceKey, "allowed", globalSettings.isAllowedSpace(spaceKey))).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GitLabConfiguration save(GitLabConfiguration configuration) {
        GitLabConfiguration existingConfiguration;
        if ("********".equals(configuration.getApiKey()) && configuration.getId() != null && configuration.getId() != 0 && (existingConfiguration = (GitLabConfiguration)this.configurationService.get(configuration.getId())) != null) {
            configuration.setApiKey(existingConfiguration.getApiKey());
        }
        GitLabConfiguration result = this.configurationService.save(configuration);
        return this.hideKey(result);
    }

    @DELETE
    @Produces(value={"application/json"})
    public GitLabConfiguration delete(@QueryParam(value="id") Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("ID is null");
        }
        return this.hideKey((GitLabConfiguration)this.configurationService.delete(id));
    }

    public GitLabConfiguration hideKey(GitLabConfiguration configuration) {
        if (configuration != null && StringUtils.isNotBlank((CharSequence)configuration.getApiKey())) {
            configuration = configuration.clone();
            configuration.setApiKey("********");
        }
        return configuration;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonAutoDetect
    public static class EffectiveSettings {
        private GlobalSettings globalSettings;
        private List<GitLabConfiguration> configurations = new ArrayList<GitLabConfiguration>();

        @Generated
        public EffectiveSettings() {
        }

        @Generated
        public GlobalSettings getGlobalSettings() {
            return this.globalSettings;
        }

        @Generated
        public List<GitLabConfiguration> getConfigurations() {
            return this.configurations;
        }

        @Generated
        public void setGlobalSettings(GlobalSettings globalSettings) {
            this.globalSettings = globalSettings;
        }

        @Generated
        public void setConfigurations(List<GitLabConfiguration> configurations) {
            this.configurations = configurations;
        }

        @Generated
        public String toString() {
            return "ConfigResource.EffectiveSettings(super=" + super.toString() + ", globalSettings=" + this.getGlobalSettings() + ", configurations=" + this.getConfigurations() + ")";
        }
    }
}

