/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabJob;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.macros.BaseGitLabMacro;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="buildsMacro")
public class BuildsMacro
extends BaseGitLabMacro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildsMacro.class);
    public static final String PROJECT_PARAMETER = "project";
    public static final String MAX_ITEMS_SHOWN_PARAMETER = "maxItemsShown";
    public static final String TEMPLATES_BUILDS_MACRO = "templates/builds-macro.vm";

    @Autowired
    public BuildsMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider) {
        super(gitlabApi, configurationManager, licenseManager, i18nResolver, webResourceUrlProvider);
    }

    @Override
    public String doExecute(Map<String, String> parameters, String bodyContent, GitlabConnection connection, ConversionContext conversionContext) throws Exception {
        String projectId = URLDecoder.decode(parameters.get(PROJECT_PARAMETER), StandardCharsets.UTF_8.displayName());
        int maxItemsShown = 10;
        try {
            maxItemsShown = Integer.parseInt(parameters.getOrDefault(MAX_ITEMS_SHOWN_PARAMETER, String.valueOf(maxItemsShown)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<GitlabJob> builds = null;
        GitlabProject project = null;
        try {
            project = this.gitlabApi.getProject(connection, (Serializable)((Object)projectId), false);
            builds = this.gitlabApi.getBuilds(connection, project.getId(), maxItemsShown);
        }
        catch (Exception e) {
            log.error(String.format("error on fetching builds for key %s", projectId), (Throwable)e);
            throw e;
        }
        if (maxItemsShown < builds.size()) {
            builds = builds.subList(0, maxItemsShown);
        }
        Map context = MacroUtils.defaultVelocityContext();
        context.put("gitLabUrl", connection.getUrl());
        context.put(PROJECT_PARAMETER, project);
        context.put("builds", builds);
        return VelocityUtils.getRenderedTemplate((String)TEMPLATES_BUILDS_MACRO, (Map)context);
    }

    @Override
    protected String getMacroErrorPrefix() {
        return this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.buildmacro.error");
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

