/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.components;

import at.rumpelcoders.confluence.ao.GitLabRepository;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.model.GlobalSettings;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationManager.class);
    private final GitLabRepository pluginRepository;

    @Autowired
    public ConfigurationManager(GitLabRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    public GlobalSettings getGlobalSettings() {
        GlobalSettings globalSettings = this.pluginRepository.getByKey("05f11044-da77-41a8-ac66-a9388ffd0925", GlobalSettings.class);
        return globalSettings != null ? globalSettings : new GlobalSettings();
    }

    public GitLabConfiguration getGlobalConfiguration() {
        List<GitLabConfiguration> configurations = this.pluginRepository.getByTag("05f11044-da77-41a8-ac66-a9388ffd0925", GitLabConfiguration.class);
        return CollectionUtils.isEmpty(configurations) ? new GitLabConfiguration() : configurations.get(0);
    }

    public GitLabConfiguration getPersonalConfiguration(String userKey) {
        List<GitLabConfiguration> configurations = this.pluginRepository.getByTag(userKey, GitLabConfiguration.class);
        return CollectionUtils.isEmpty(configurations) ? new GitLabConfiguration() : configurations.get(0);
    }

    public List<GitLabConfiguration> getPossibleConfigurations() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        ArrayList<GitLabConfiguration> configurations = new ArrayList<GitLabConfiguration>();
        configurations.addAll(this.pluginRepository.getByTag(confluenceUser.getKey().getStringValue(), GitLabConfiguration.class));
        configurations.addAll(this.pluginRepository.getByTag("05f11044-da77-41a8-ac66-a9388ffd0925", GitLabConfiguration.class));
        TreeSet<GitLabConfiguration> set = new TreeSet<GitLabConfiguration>(Comparator.nullsFirst(Comparator.comparing(GitLabConfiguration::getServerUrl, String.CASE_INSENSITIVE_ORDER)));
        set.addAll(configurations);
        return new ArrayList<GitLabConfiguration>(set);
    }

    public List<GitLabConfiguration> getSuitableConfigurations(String baseUrl) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        HashMap configurationMap = new HashMap();
        List<GitLabConfiguration> configurations = this.pluginRepository.getByTag("05f11044-da77-41a8-ac66-a9388ffd0925", GitLabConfiguration.class);
        this.filterConfigurationsByBaseUrl(configurations, baseUrl);
        configurations.forEach(configuration -> configurationMap.put(configuration.getServerUrl(), configuration));
        configurations = this.pluginRepository.getByTag(confluenceUser.getKey().getStringValue(), GitLabConfiguration.class);
        this.filterConfigurationsByBaseUrl(configurations, baseUrl);
        configurations.forEach(configuration -> configurationMap.put(configuration.getServerUrl(), configuration));
        return new ArrayList<GitLabConfiguration>(configurationMap.values());
    }

    private void filterConfigurationsByBaseUrl(List<GitLabConfiguration> configurations, String baseUrl) {
        configurations.removeIf(configuration -> StringUtils.isBlank((CharSequence)configuration.getServerUrl()));
        if (StringUtils.isNotBlank((CharSequence)baseUrl)) {
            configurations.removeIf(configuration -> !baseUrl.equals(configuration.getServerUrl()));
        }
    }
}

