AJS.toInit(function () {
    var baseUrl = AJS.$("meta[name='application-base-url']").attr("content");
    var url = AJS.contextPath() + "/rest/rumpelcoders/gitlab-api/1.0/config";
    var checkUrl = AJS.contextPath() + "/rest/rumpelcoders/gitlab-api/1.0/checkconfig";

    spaceSelect($("#allowedSpaces"));
    spaceSelect($("#forbiddenSpaces"));

    function spaceSelect(select) {
        select.mwfSelect2({
            ajax: {
                url: function (params) {
                    return AJS.contextPath() + '/rest/api/search?cql=type=space%20and%20space.title~"' + params.term + '*"';
                },
                type: "GET",
                processResults: function (data) {
                    var results = [];
                    for(var i = 0; i < data.results.length; i ++) {
                        var space = data.results[i]["space"];
                        results.push({id: space["key"], text: space["name"]});
                    }
                    return {
                        results: results
                    };
                }
            }
        });
    }

    function saveConfig() {
        var data = {
            id: AJS.$("#id").val(),
            level: AJS.$("#level").val(),
            userKey: AJS.$("#userKey").val(),
            serverUrl: AJS.$("#serverUrl").val(),
            apiKey: AJS.$("#apiKey").val(),
            tokenType: AJS.$("[name='tokenType']").val(),
            hostType: AJS.$("[name='hostType']").val(),
            requestTimeout: AJS.$("[name='requestTimeout']").val(),
            allowedSpaces: AJS.$("[name='allowedSpaces']").val(),
            forbiddenSpaces: AJS.$("[name='forbiddenSpaces']").val(),
            autoconversionEnabled: AJS.$("#autoconversionEnabled").is(":checked")
        };
        AJS.$.ajax({
            url: url,
            type: "POST",
            contentType: "application/json",
            data: JSON.stringify(data)
        }).done(function (data) {
           message("#result-ajax", $('#result-text-success').val(), AJS.messages.success, true);
           AJS.$("#id").val(data["id"]);
        }).fail(function (xhr) {
            message("#result-ajax", xhr.statusText + (": " + xhr.responseText) || "", AJS.messages.error);
        });
    }

    function deleteConfig() {
        var id = AJS.$("#id").val();
        if(typeof id === 'undefined' || id === null || id === '') {
            return;
        }

        AJS.$.ajax({
            url: url + "?id=" + id,
            type: "DELETE",
            contentType: "application/json"
        }).done(function (data) {
            location.reload();
        }).fail(function (xhr) {
           message("#result-ajax", xhr.statusText + (": " + xhr.responseText) || "", AJS.messages.error);
        });
    }

    function message(id, text, func, fadeout) {
            AJS.$(id).empty();
            func.apply(AJS.messages, [id, {
                closeable: true,
                fadeout: fadeout,
                body: text
            }]);
        }

    function checkConnection() {
        var data = {
            id: AJS.$("#id").val(),
            serverUrl: AJS.$("#serverUrl").val(),
            apiKey: AJS.$("#apiKey").val(),
            tokenType: AJS.$("[name='tokenType']:checked").val(),
            hostType: AJS.$("[name='hostType']:checked").val(),
            requestTimeout: AJS.$("[name='requestTimeout']").val()
        };
        $('#result-ajax').html('... Checking connection ...');
        AJS.$.ajax({
            url: checkUrl,
            type: "POST",
            contentType: "application/json",
            data: JSON.stringify(data)
        }).done(function (data) {
            var text = $('<p style="color: red"></p>').html($('#result-check-text-error').val());
            console.log(data);
            if(data.hasOwnProperty("connectionOk") && data.connectionOk) {
                text = $('<p style="color: green"></p>').html($('#result-check-text-success').val());
            }
            $('#result-ajax').html(text).fadeOut(3500, resetAfterFadeOut);
        }).fail(function (xhr) {
            $('#result-ajax').html($('#result-check-text-error').val()).fadeOut(3500, resetAfterFadeOut);
        });
    }

    function resetAfterFadeOut() {
        $(this).html('');
        $(this).css('display', 'block');
    }

    AJS.$('#checkConnection').on('click', function(e){
        e.preventDefault();
        checkConnection();
    });

    AJS.$('#deleteConnection').on('click', function(e) {
        e.preventDefault();
        deleteConfig();
    });

    AJS.$("#admin").submit(function (e) {
        e.preventDefault();
        saveConfig();
    });

    try {
        let surveyData = AJS.$("#surveyData");
        if(surveyData.length > 0) {
            let submitted = false;
            let hidden = {};
            surveyData.find("input").each((i, element) => {
                let el = AJS.$(element);
                hidden[el.attr("name")] = el.val();
            });
            const {open, close, toggle, refresh} = window.tf.createPopup(surveyData.attr('data-val'), {
                mode: 'popup',
                autoClose: true,
                hideHeaders: true,
                hideFooters: true,
                width: "600px",
                height: "400px",
                open: 'time',
                openValue: 20000,
                preventReopenOnClose: true,
                hidden: hidden,
                onSubmit: function () {
                    submitted = true;
                    AJS.$.ajax({
                        url: AJS.contextPath() + '/rest/rumpelcoders/gitlab-api/1.0/survey/submit/' + surveyData.attr('data-val'),
                        type: "POST",
                        dataType: "json",
                        contentType: "application/json",
                        async: true,
                        error: function(xhr) {
                            console.error(xhr.statusText + (": " + xhr.responseText) || "");
                            submitted = false;
                        },
                        success: function(response) {
                            console.log("Survey submitted");
                        }
                    });
                },
                onClose: function () {
                    if(!submitted) {
                        AJS.$.ajax({
                            url: AJS.contextPath() + '/rest/rumpelcoders/gitlab-api/1.0/survey/close/' + surveyData.attr('data-val'),
                            type: "POST",
                            dataType: "json",
                            contentType: "application/json",
                            async: true,
                            error: function(xhr) {
                                console.error(xhr.statusText + (": " + xhr.responseText) || "");
                                submitted = false;
                            },
                            success: function(response) {
                                console.log("Survey closed");
                            }
                        });
                    }
                }
            });
            open();
        }
    } catch (error) {
        console.error(error);
    }

});

