(function($) {
    var spaceKey = AJS.$("meta[name='ajs-space-key']").attr("content");
    var spaceAllowed = true;
    AJS.$.ajax({
        async: false,
        url: AJS.contextPath() + "/rest/rumpelcoders/gitlab-api/1.0/config/checkSpace/" + spaceKey,
        dataType: 'json',
        timeout: 10000,
        error: function(xhr, textStatus, errorThrown) {
            AJS.logError(errorThrown);
            spaceAllowed = true;
        },
        success: function(response) {
            spaceAllowed = response.allowed;
        }
    });

    var GitLabConnectorMacro = function() {};
    var originalGroup;
    var originalEpic;
    var originalTag;

    GitLabConnectorMacro.prototype.fields = {
        "enum": {
            "group": function(param, options) {
                console.log("group function", param, options);
                var paramDiv = AJS.$(Confluence.Templates.MacroBrowser.macroParameterSelect());
                var groupDropDown = AJS.$("select", paramDiv);
                loadGroups(groupDropDown);
                console.log(paramDiv, groupDropDown, options);
                return new AJS.MacroBrowser.Field(paramDiv, groupDropDown, options);
            },
            "epic": function(param, options) {
                var paramDiv = AJS.$(Confluence.Templates.MacroBrowser.macroParameterSelect());
                var epicDropdown = AJS.$("select", paramDiv);
                if (!originalEpic) {
                    epicDropdown.prop('disabled', true);
                } else {
                    epicDropdown.prop('disabled', false);
                    setupEpic(epicDropdown);
                }
                $('select#macro-param-group').change(function() {
                    updateEpic(epicDropdown, this.value);
                });
                return new AJS.MacroBrowser.Field(paramDiv, epicDropdown, options);
            },
            "tag": function(param, options) {
                var paramDiv = AJS.$(Confluence.Templates.MacroBrowser.macroParameterSelect());
                var tagDropdown = AJS.$("select", paramDiv);
                if (!originalTag) {
                    tagDropdown.prop('disabled', true);
                } else {
                    tagDropdown.prop('disabled', false);
                    setupTag(tagDropdown);
                }
                $('input#macro-param-project').change(function() {
                    updateTag(tagDropdown, this.value);
                });
                return new AJS.MacroBrowser.Field(paramDiv, tagDropdown, options);
            }
        },
        "boolean": {
            "useSnippetId": function (param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["boolean"](param, options);
                var input = AJS.$(parameterField.input);
                input.change(function() {
                    if($(this).is(":checked")) {
                        $('div#macro-param-div-snippetId').show();
                        $('div#macro-param-div-projectNameWithNamespace').hide();
                        $('div#macro-param-div-projectName').hide();
                        $('div#macro-param-div-snippetTitle').hide();
                    } else {
                        $('div#macro-param-div-snippetId').hide();
                        $('div#macro-param-div-projectNameWithNamespace').show();
                        $('div#macro-param-div-projectName').show();
                        $('div#macro-param-div-snippetTitle').show();
                    }

                });
                return parameterField;
            },
        },
        "string": {
            "filter": function(param, options) {},
            "link": function(param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["_hidden"](param, options);
                var link = AJS.$(parameterField.input);
                return parameterField;
            },
            "project": function(param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["_hidden"](param, options);
                var project = AJS.$(parameterField.input);
                return parameterField;
            },
            "projectNameWithNamespace": function(param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["string"](param, options);
                var project = AJS.$(parameterField.input);
                project.prop('disabled', true);
                return parameterField;
            },
            "projectName": function(param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["string"](param, options);
                var project = AJS.$(parameterField.input);

                project.autocompleteMacro({
                    serviceUrl: AJS.contextPath() + "/rest/rumpelcoders/gitlab-api/1.0/projects/search",
                    paramName: "text",
                    dataType: "json",
                    minChars: 3,
                    deferRequestBy: 1000,
                    onSelect: function(suggestion) {
                        $('#macro-param-project').val(suggestion["data"]).change();
                        $('#macro-param-projectNameWithNamespace').val(suggestion["nameWithNamespace"]).change();
                    },
                    onSearchError: function(text, response) {
                        try {
                            var gitLabError = JSON.parse(response.responseText)
                            $('<div style="color: red">' + gitLabError.message + '</div>').insertAfter($("#macro-param-projectName").next())
                                .fadeOut(3500, function() {
                                    $(this).remove();
                                })
                        } catch (error) {
                            $('<div style="color: red">' + response.responseText + '</div>').insertAfter($("#macro-param-projectName").next())
                                .fadeOut(3500, function() {
                                    $(this).remove();
                                })
                        }
                    },
                    transformResult: function(response, originalQuery) {
                        var suggestions = [];
                        if (typeof response !== 'undefined') {
                            var json = {};
                            if (response === 'string') {
                                json = JSON.parse(response.trim())
                            } else {
                                json = response;
                            }
                            suggestions = json.map(function(data) {
                                var entry = {};
                                entry["value"] = data.name;
                                entry["data"] = data.id;
                                entry["nameWithNamespace"] = data.nameWithNamespace;
                                return entry;
                            });
                        }
                        var result = {};
                        result["suggestions"] = suggestions;
                        return result;
                    }
                });

                return parameterField;
            },
            "issue": function(param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["_hidden"](param, options);
                return parameterField;
            },
            "issueName": function(param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["string"](param, options);
                var issue = AJS.$(parameterField.input);
                issue.autocompleteMacro({
                    serviceUrl: function() {
                        var projectId = $('#macro-param-project').val();
                        return AJS.contextPath() + "/rest/rumpelcoders/gitlab-api/1.0/projects/issues/search?projectId=" + projectId;
                    },
                    preventBadQueries: false,
                    paramName: "text",
                    dataType: "json",
                    minChars: 3,
                    deferRequestBy: 1000,
                    onSelect: function(suggestion) {
                        $('#macro-param-issue').val(suggestion["data"]).change();
                    },
                    onSearchError: function(text, response) {
                        try {
                            var gitLabError = JSON.parse(response.responseText)
                            $('<div style="color: red">' + gitLabError.message + '</div>').insertAfter($("#macro-param-issueName").next())
                                .fadeOut(3500, function() {
                                    $(this).remove();
                                })
                        } catch (error) {
                            $('<div style="color: red">' + response.responseText + '</div>').insertAfter($("#macro-param-issueName").next())
                                .fadeOut(3500, function() {
                                    $(this).remove();
                                })
                        }
                    },
                    transformResult: function(response, originalQuery) {
                        var suggestions = [];
                        if (typeof response !== 'undefined') {
                            var json = {};
                            if (response === 'string') {
                                json = JSON.parse(response.trim())
                            } else {
                                json = response;
                            }
                            suggestions = json.map(function(data) {
                                var entry = {};
                                entry["value"] = data.name;
                                entry["data"] = data.id;
                                return entry;
                            });
                        }
                        var result = {};
                        result["suggestions"] = suggestions;
                        return result;
                    }
                });

                $('input#macro-param-project').change(function() {
                    issue.val('');
                    $('input#macro-param-issue').val('');
                });
                return parameterField;
            },
            "snippetId": function(param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["string"](param, options);
                return parameterField;
            },
            "snippetTitle": function(param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["string"](param, options);
                var snippet = AJS.$(parameterField.input);
                snippet.autocompleteMacro({
                    serviceUrl: function() {
                        var projectId = $('#macro-param-project').val();
                        return AJS.contextPath() + "/rest/rumpelcoders/gitlab-api/1.0/projects/snippets/search?projectId=" + projectId;
                    },
                    preventBadQueries: false,
                    paramName: "text",
                    dataType: "json",
                    minChars: 3,
                    deferRequestBy: 1000,
                    onSelect: function(suggestion) {
                        $('#macro-param-snippetId').val(suggestion["data"]).change();
                    },
                    onSearchError: function(text, response) {
                        try {
                            var gitLabError = JSON.parse(response.responseText)
                            $('<div style="color: red">' + gitLabError.message + '</div>').insertAfter($("#macro-param-snippetTitle").next())
                                .fadeOut(3500, function() {
                                    $(this).remove();
                                })
                        } catch (error) {
                            $('<div style="color: red">' + response.responseText + '</div>').insertAfter($("#macro-param-snippetTitle").next())
                                .fadeOut(3500, function() {
                                    $(this).remove();
                                })
                        }
                    },
                    transformResult: function(response, originalQuery) {
                        var suggestions = [];
                        if (typeof response !== 'undefined') {
                            var json = {};
                            if (response === 'string') {
                                json = JSON.parse(response.trim())
                            } else {
                                json = response;
                            }
                            suggestions = json.map(function(data) {
                                var entry = {};
                                entry["value"] = data.name;
                                entry["data"] = data.id;
                                return entry;
                            });
                        }
                        var result = {};
                        result["suggestions"] = suggestions;
                        return result;
                    }
                });

                $('input#macro-param-project').change(function() {
                    snippet.val('');
                    $('input#macro-param-snippetId').val('');
                });
                return parameterField;
            }
        }
    };

    GitLabConnectorMacro.prototype.beforeParamsSet = function(selectedParams, macroSelected) {
        if (!spaceAllowed) {
            var macroDesc = $("#macro-insert-container").find(".macro-desc");
            macroDesc.html("Macro is not allowed for this space. Contact administrator to solve the issue.");
            macroDesc.css("border", "1px solid #ff5630");
            macroDesc.css("border-radius", "3px");
            macroDesc.css("padding", "5px");
            macroDesc.parent("form").find(".macro-param-div").remove();
        }
        //backward compatibility
        if (selectedParams.hasOwnProperty('isMarkDown')) {
            var isMarkDown = selectedParams.isMarkDown;
            if(isMarkDown) {
                $('select#macro-param-fileType').val("Mark Down");
            }
        } else if (!selectedParams.hasOwnProperty('fileType') && $('select#macro-param-fileType').length > 0) {
            $('select#macro-param-fileType').val("None");
        }
        if (selectedParams.hasOwnProperty('project')) {
            var projectId = selectedParams.project;
            $('input#macro-param-issue').prop('disabled', false);
            //load project name if it was not set
            if (!selectedParams.hasOwnProperty('projectName')) {
                AJS.$.ajax({
                    async: false,
                    url: AJS.contextPath() + "/rest/rumpelcoders/gitlab-api/1.0/projects?projectId=" + projectId,
                    dataType: 'json',
                    timeout: 60000,
                    error: function(xhr, textStatus, errorThrown) {
                        AJS.logError(errorThrown);
                    },
                    success: function(response) {
                        selectedParams["projectName"] = response.name;
                        selectedParams["projectNameWithNamespace"] = response.nameWithNamespace;
                    }
                });
            }
        }
        if (selectedParams.hasOwnProperty('issue')) {
            var projectId = selectedParams.project;
            var issueId = selectedParams.issue;
            //loads issue title if it was not set
            if (!selectedParams.hasOwnProperty('issueName')) {
                AJS.$.ajax({
                    async: false,
                    url: AJS.contextPath() + "/rest/rumpelcoders/gitlab-api/1.0/projects/issues?projectId=" + projectId + "&issueId=" + issueId,
                    dataType: 'json',
                    timeout: 60000,
                    error: function(xhr, textStatus, errorThrown) {
                        AJS.logError(errorThrown);
                    },
                    success: function(response) {
                        selectedParams["issueName"] = response.name;
                    }
                });
            }
        }
        if (selectedParams.hasOwnProperty('group')) {
            originalGroup = selectedParams.group;
        }
        if (selectedParams.hasOwnProperty('epic')) {
            originalEpic = selectedParams.epic;
        }
        if (selectedParams.hasOwnProperty('tag')) {
            originalTag = selectedParams.tag;
            if(originalTag) {
                updateTag($('select#macro-param-tag'), selectedParams.project);
            }
        }
        if (selectedParams.hasOwnProperty('useSnippetId') && selectedParams.useSnippetId) {
            $('div#macro-param-div-snippetId').show();
            $('div#macro-param-div-projectNameWithNamespace').hide();
            $('div#macro-param-div-projectName').hide();
            $('div#macro-param-div-snippetTitle').hide();
        } else if($('div#macro-param-div-snippetId').length > 0) {
            $('div#macro-param-div-snippetId').hide();
            $('div#macro-param-div-projectNameWithNamespace').show();
            $('div#macro-param-div-projectName').show();
            $('div#macro-param-div-snippetTitle').show();
        }
        return selectedParams;
    };

    function setupEpic(epicDropdown) {
        if (originalEpic) {
            $('select#macro-param-epic').val(originalEpic).change();
        }
    }

    function setupTag(tagDropdown) {
        console.log("TEST" + originalTag)
        if (originalTag) {
            $('select#macro-param-tag').val(originalTag).change();
        }
    }

    function loadGroups(groupDropDown) {
        groupDropDown.empty();
        groupDropDown.append($("<option>Loading groups ...</option>"));
        AJS.$.ajax({
            async: true,
            url: AJS.contextPath() + "/rest/rumpelcoders/gitlab-api/1.0/groups",
            dataType: 'json',
            timeout: 10000,
            error: function(xhr, textStatus, errorThrown) {
                AJS.logError(errorThrown);
                console.error("Error on fetching gitlab data: " + errorThrown);
                groupDropDown.empty();
                groupDropDown.append($("<option>Error on loading group list</option>"));
            },
            success: function(response) {
                groupDropDown.empty();
                groupDropDown.append($("<option>None</option>"));
                for (var i = 0; i < response.length; i++) {
                    groupDropDown.append($("<option></option>").val(response[i].id).html(response[i].name));
                }
                if (originalGroup) {
                    $('select#macro-param-group').val(originalGroup).change();
                }
            }
        });
    }

    function updateTag(tagDropdown, projectId) {
        if (projectId !== "None") {
            AJS.$.ajax({
                async: true,
                url: AJS.contextPath() + "/rest/rumpelcoders/gitlab-api/1.0/projects/releases?projectId=" + projectId,
                dataType: 'json',
                timeout: 10000,
                error: function(xhr, textStatus, errorThrown) {
                    AJS.logError(errorThrown);
                    console.log("THERE WAS AN ERROR:" + errorThrown);
                },
                success: function(response) {
                    tagDropdown.empty();
                    tagDropdown.append($("<option>The latest</option>").attr("value", "latest"));
                    tagDropdown.prop('disabled', false);
                    for (var i = 0; i < response.length; i++) {
                        tagDropdown.append($("<option></option>").val(response[i].key).html(response[i].value));
                    }
                    setupTag(tagDropdown);
                }
            });
        } else {
            tagDropdown.empty();
            tagDropdown.append($("<option>None</option>").attr("value", ""));
        }
    }

    function updateEpic(epicDropdown, groupId) {
        if (groupId !== "None") {
            AJS.$.ajax({
                async: true,
                url: AJS.contextPath() + "/rest/rumpelcoders/gitlab-api/1.0/groups/" + groupId + "/epics",
                dataType: 'json',
                timeout: 10000,
                error: function(xhr, textStatus, errorThrown) {
                    AJS.logError(errorThrown);
                    console.log("THERE WAS AN ERROR:" + errorThrown);
                },
                success: function(response) {
                    epicDropdown.empty();
                    epicDropdown.append($("<option>None</option>").attr("value", ""));
                    epicDropdown.prop('disabled', false);
                    for (var i = 0; i < response.length; i++) {
                        epicDropdown.append($("<option></option>").val(response[i].id).html(response[i].name));
                    }
                    setupEpic(epicDropdown);
                }
            });
        } else {
            epicDropdown.empty();
            epicDropdown.append($("<option>None</option>").attr("value", ""));
        }
    }

    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-issue", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-list-issues", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-list-projects", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-project", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-list-builds", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-list-mergerequests", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-epic", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-file", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-snippet", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-list-groups", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-commit", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-release", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-list-milestones", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-milestone", new GitLabConnectorMacro());

})(AJS.$);