/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.ctreber.acearth.util;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import zext.plantuml.com.ctreber.acearth.util.Coordinate;
import zext.plantuml.com.ctreber.acearth.util.Toolkit;

public class SunPositionCalculator {
    private static final long EPOCH_START = 631065600000L;
    private static final double RADS_PER_DAY = 0.017202791632524146;
    private static final double EPSILON_G = Toolkit.degsToRads(279.403303);
    private static final double OMEGA_BAR_G = Toolkit.degsToRads(282.768422);
    private static final double ECCENTRICITY = 0.016713;
    private static final double MOON_MEAN_LONGITUDE = Toolkit.degsToRads(318.351648);
    private static final double MOON_MEAN_LONGITUDE_PERIGEE = Toolkit.degsToRads(36.34041);
    private static final double MOON_MEAN_LONGITUDE_NODE = Toolkit.degsToRads(318.510107);
    private static final double MOON_INCLINATION = Toolkit.degsToRads(5.145396);
    private static final double SIDERAL_MONTH = 27.3217;

    private static double getMeanSunLongitude(double pDays) {
        double M;
        double N2 = 0.017202791632524146 * pDays;
        if ((N2 = Toolkit.fmod(N2, 0.0, Math.PI * 2)) < 0.0) {
            N2 += Math.PI * 2;
        }
        if ((M = N2 + EPSILON_G - OMEGA_BAR_G) < 0.0) {
            M += Math.PI * 2;
        }
        return M;
    }

    private static double getSunEclipticLongitude(long pMillis) {
        double lDays = SunPositionCalculator.daysSinceEpoch(pMillis);
        double M_sun = SunPositionCalculator.getMeanSunLongitude(lDays);
        double E = SunPositionCalculator.doKepler(M_sun);
        double v = 2.0 * Math.atan(Math.sqrt(1.033994144130859) * Math.tan(E / 2.0));
        return v + OMEGA_BAR_G;
    }

    static double daysSinceEpoch(long pMillis) {
        return (double)(pMillis - 631065600000L) / 24.0 / 3600.0 / 1000.0;
    }

    private static double doKepler(double M) {
        double lDelta;
        double E = M;
        while (!(Math.abs(lDelta = E - 0.016713 * Math.sin(E) - M) <= 1.0E-10)) {
            E -= lDelta / (1.0 - 0.016713 * Math.cos(E));
        }
        return E;
    }

    private static double getJulianDate(int pYear, int pMonth, int pDay) {
        if (pMonth == 1 || pMonth == 2) {
            --pYear;
            pMonth += 12;
        }
        int A2 = pYear / 100;
        int B = 2 - A2 + A2 / 4;
        int C2 = (int)(365.25 * (double)pYear);
        int D = (int)(30.6001 * (double)(pMonth + 1));
        return (double)(B + C2 + D + pDay) + 1720994.5;
    }

    private static double getGST(long pMillis) {
        Calendar lCal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        lCal.setTime(new Date(pMillis));
        double lJulianDate = SunPositionCalculator.getJulianDate(lCal.get(1), lCal.get(2) + 1, lCal.get(5));
        double T = (lJulianDate - 2451545.0) / 36525.0;
        double T0 = ((T + 2.5862E-5) * T + 2400.051336) * T + 6.697374558;
        T0 = Toolkit.fmod(T0, 0.0, 24.0);
        if (T0 < 0.0) {
            T0 += 24.0;
        }
        double UT = (double)lCal.get(11) + ((double)lCal.get(12) + (double)lCal.get(13) / 60.0) / 60.0;
        T0 += UT * 1.002737909;
        if ((T0 = Toolkit.fmod(T0, 0.0, 24.0)) < 0.0) {
            T0 += 24.0;
        }
        return T0;
    }

    public static Coordinate getSunPositionOnEarth(long pMillis) {
        Coordinate lSunPosEc = new Coordinate(0.0, SunPositionCalculator.getSunEclipticLongitude(pMillis));
        Coordinate lSunPosEq = lSunPosEc.eclipticToEquatorial();
        double lRA = Toolkit.limitRads(lSunPosEq.getRA() - 0.2617993877991494 * SunPositionCalculator.getGST(pMillis));
        return new Coordinate(Toolkit.radsToDegs(lSunPosEq.getDE()), Toolkit.radsToDegs(lRA));
    }

    public static Coordinate getMoonPositionOnEarth(long pMillis) {
        double lDays = SunPositionCalculator.daysSinceEpoch(pMillis);
        double lSunLongEc = SunPositionCalculator.getSunEclipticLongitude(pMillis);
        double Ms = SunPositionCalculator.getMeanSunLongitude(lDays);
        double L = Toolkit.limitRads(Toolkit.fmod(lDays / 27.3217, 0.0, 1.0) * (Math.PI * 2) + MOON_MEAN_LONGITUDE);
        double Mm = Toolkit.limitRads(L - Toolkit.degsToRads(0.1114041 * lDays) - MOON_MEAN_LONGITUDE_PERIGEE);
        double N2 = Toolkit.limitRads(MOON_MEAN_LONGITUDE_NODE - Toolkit.degsToRads(0.0529539 * lDays));
        double Ev = Toolkit.degsToRads(1.2739) * Math.sin(2.0 * (L - lSunLongEc) - Mm);
        double Ae = Toolkit.degsToRads(0.1858) * Math.sin(Ms);
        double Ec = Toolkit.degsToRads(6.2886) * Math.sin(Mm += Ev - Ae - Toolkit.degsToRads(0.37) * Math.sin(Ms));
        L += Ev + Ec - Ae + Toolkit.degsToRads(0.214) * Math.sin(2.0 * Mm);
        L += Toolkit.degsToRads(0.6583) * Math.sin(2.0 * (L - lSunLongEc));
        lSunLongEc = Toolkit.limitRads(Math.abs(Math.cos(L -= (N2 -= Toolkit.degsToRads(0.16) * Math.sin(Ms)))) < 1.0E-12 ? N2 + Math.sin(L) * Math.cos(MOON_INCLINATION) * Math.PI / 2.0 : N2 + Math.atan2(Math.sin(L) * Math.cos(MOON_INCLINATION), Math.cos(L)));
        double lSunLatEc = Math.asin(Math.sin(L) * Math.sin(MOON_INCLINATION));
        Coordinate lSunPosEq = new Coordinate(lSunLatEc, lSunLongEc).eclipticToEquatorial();
        double lRA = Toolkit.limitRads(lSunPosEq.getRA() - 0.2617993877991494 * SunPositionCalculator.getGST(pMillis));
        return new Coordinate(Toolkit.radsToDegs(lSunPosEq.getDE()), Toolkit.radsToDegs(lRA));
    }
}

