/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal.util;

public class Parsing {
    private static final String TAGNAME = "[A-Za-z][A-Za-z0-9-]*";
    private static final String ATTRIBUTENAME = "[a-zA-Z_:][a-zA-Z0-9:._-]*";
    private static final String UNQUOTEDVALUE = "[^\"'=<>`\\x00-\\x20]+";
    private static final String SINGLEQUOTEDVALUE = "'[^']*'";
    private static final String DOUBLEQUOTEDVALUE = "\"[^\"]*\"";
    private static final String ATTRIBUTEVALUE = "(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\")";
    private static final String ATTRIBUTEVALUESPEC = "(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))";
    private static final String ATTRIBUTE = "(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)";
    public static final String OPENTAG = "<[A-Za-z][A-Za-z0-9-]*(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>";
    public static final String CLOSETAG = "</[A-Za-z][A-Za-z0-9-]*\\s*[>]";
    public static int CODE_BLOCK_INDENT = 4;

    public static int columnsToNextTabStop(int column) {
        return 4 - column % 4;
    }

    public static int find(char c, CharSequence s2, int startIndex) {
        int length = s2.length();
        for (int i = startIndex; i < length; ++i) {
            if (s2.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int findLineBreak(CharSequence s2, int startIndex) {
        int length = s2.length();
        for (int i = startIndex; i < length; ++i) {
            switch (s2.charAt(i)) {
                case '\n': 
                case '\r': {
                    return i;
                }
            }
        }
        return -1;
    }

    public static boolean isBlank(CharSequence s2) {
        return Parsing.findNonSpace(s2, 0) == -1;
    }

    public static boolean hasNonSpace(CharSequence s2) {
        int length = s2.length();
        int skipped = Parsing.skip(' ', s2, 0, length);
        return skipped != length;
    }

    public static boolean isLetter(CharSequence s2, int index) {
        int codePoint = Character.codePointAt(s2, index);
        return Character.isLetter(codePoint);
    }

    public static boolean isSpaceOrTab(CharSequence s2, int index) {
        if (index < s2.length()) {
            switch (s2.charAt(index)) {
                case '\t': 
                case ' ': {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isEscapable(char c) {
        switch (c) {
            case '!': 
            case '\"': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '_': 
            case '`': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static CharSequence prepareLine(CharSequence line) {
        StringBuilder sb = null;
        int length = line.length();
        for (int i = 0; i < length; ++i) {
            char c = line.charAt(i);
            if (c == '\u0000') {
                if (sb == null) {
                    sb = new StringBuilder(length);
                    sb.append(line, 0, i);
                }
                sb.append('\ufffd');
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb != null) {
            return sb.toString();
        }
        return line;
    }

    public static int skip(char skip, CharSequence s2, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            if (s2.charAt(i) == skip) continue;
            return i;
        }
        return endIndex;
    }

    public static int skipBackwards(char skip, CharSequence s2, int startIndex, int lastIndex) {
        for (int i = startIndex; i >= lastIndex; --i) {
            if (s2.charAt(i) == skip) continue;
            return i;
        }
        return lastIndex - 1;
    }

    public static int skipSpaceTab(CharSequence s2, int startIndex, int endIndex) {
        block3: for (int i = startIndex; i < endIndex; ++i) {
            switch (s2.charAt(i)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return endIndex;
    }

    public static int skipSpaceTabBackwards(CharSequence s2, int startIndex, int lastIndex) {
        block3: for (int i = startIndex; i >= lastIndex; --i) {
            switch (s2.charAt(i)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return lastIndex - 1;
    }

    private static int findNonSpace(CharSequence s2, int startIndex) {
        int length = s2.length();
        block3: for (int i = startIndex; i < length; ++i) {
            switch (s2.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return -1;
    }
}

