/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.ReadLineSimple;
import net.sourceforge.plantuml.preproc.StartDiagramExtractReader;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.utils.Log;

public class PreprocessorUtils {
    public static String withEnvironmentVariable(String s2) {
        Pattern p = Pattern.compile("%(\\w+)%");
        Matcher m4 = p.matcher(s2);
        StringBuffer sb = new StringBuffer();
        while (m4.find()) {
            String var = m4.group(1);
            String value = PreprocessorUtils.getenv(var);
            if (value == null) continue;
            m4.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        m4.appendTail(sb);
        s2 = sb.toString();
        return s2;
    }

    public static String getenv(String var) {
        String env = System.getProperty(var);
        if (StringUtils.isNotEmpty(env)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(env);
        }
        String getenv = System.getenv(var);
        if (StringUtils.isNotEmpty(getenv)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(getenv);
        }
        return null;
    }

    private static InputStream getStdlibInputStream(String filename) {
        InputStream result = Stdlib.getResourceAsStream(filename);
        return result;
    }

    public static ReadLine getReaderNonstandardInclude(StringLocated s2, String filename) {
        if (!filename.endsWith(".puml")) {
            filename = filename + ".puml";
        }
        Log.info("Loading non standard " + filename);
        String res = "/stdlib/" + filename;
        InputStream is = Stdlib.class.getResourceAsStream(res);
        if (is == null) {
            return null;
        }
        String description = "[" + filename + "]";
        return ReadLineReader.create(new InputStreamReader(is), description);
    }

    public static ReadLine getReaderStdlibInclude(StringLocated s2, String filename) {
        Log.info("Loading sdlib " + filename);
        InputStream is = PreprocessorUtils.getStdlibInputStream(filename);
        if (is == null) {
            return null;
        }
        String description = "<" + filename + ">";
        try {
            if (StartDiagramExtractReader.containsStartDiagram(is, s2, description)) {
                is = PreprocessorUtils.getStdlibInputStream(filename);
                return StartDiagramExtractReader.build(is, s2, description);
            }
            is = PreprocessorUtils.getStdlibInputStream(filename);
            if (is == null) {
                return null;
            }
            return ReadLineReader.create(new InputStreamReader(is), description);
        }
        catch (IOException e) {
            Logme.error(e);
            return new ReadLineSimple(s2, e.toString());
        }
    }

    public static ReadLine getReaderIncludeUrl(SURL url, StringLocated s2, String suf, Charset charset) throws EaterException {
        try {
            if (StartDiagramExtractReader.containsStartDiagram(url, s2, charset)) {
                return StartDiagramExtractReader.build(url, s2, suf, charset);
            }
            return PreprocessorUtils.getReaderInclude(url, s2, charset);
        }
        catch (IOException e) {
            Logme.error(e);
            throw new EaterException("Cannot open URL " + e.getMessage(), s2);
        }
    }

    public static ReadLine getReaderInclude(SURL url, StringLocated s2, Charset charset) throws EaterException, UnsupportedEncodingException {
        InputStream is = url.openStream();
        if (is == null) {
            throw new EaterException("Cannot open URL", s2);
        }
        return ReadLineReader.create(new InputStreamReader(is, charset), url.toString(), s2.getLocation());
    }
}

